/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMusicSongOrVideoInfoItemExtractor
implements StreamInfoItemExtractor {
    private final JsonObject songOrVideoInfoItem;
    private final JsonArray descriptionElements;
    private final String searchType;

    public YoutubeMusicSongOrVideoInfoItemExtractor(JsonObject songOrVideoInfoItem, JsonArray descriptionElements, String searchType) {
        this.songOrVideoInfoItem = songOrVideoInfoItem;
        this.descriptionElements = descriptionElements;
        this.searchType = searchType;
    }

    @Override
    public String getUrl() throws ParsingException {
        String id2 = this.songOrVideoInfoItem.getObject("playlistItemData").getString("videoId");
        if (!Utils.isNullOrEmpty(id2)) {
            return "https://music.youtube.com/watch?v=" + id2;
        }
        throw new ParsingException("Could not get URL");
    }

    @Override
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.songOrVideoInfoItem.getArray("flexColumns").getObject(0).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text"));
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get name");
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() {
        return false;
    }

    @Override
    public long getDuration() throws ParsingException {
        String duration = this.descriptionElements.getObject(this.descriptionElements.size() - 1).getString("text");
        if (!Utils.isNullOrEmpty(duration)) {
            return YoutubeParsingHelper.parseDurationString(duration);
        }
        throw new ParsingException("Could not get duration");
    }

    @Override
    public String getUploaderName() throws ParsingException {
        String name = this.descriptionElements.getObject(0).getString("text");
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get uploader name");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        if (this.searchType.equals("music_videos")) {
            JsonArray items = this.songOrVideoInfoItem.getObject("menu").getObject("menuRenderer").getArray("items");
            for (Object item : items) {
                JsonObject menuNavigationItemRenderer = ((JsonObject)item).getObject("menuNavigationItemRenderer");
                if (!menuNavigationItemRenderer.getObject("icon").getString("iconType", "").equals("ARTIST")) continue;
                return YoutubeParsingHelper.getUrlFromNavigationEndpoint(menuNavigationItemRenderer.getObject("navigationEndpoint"));
            }
            return null;
        }
        JsonObject navigationEndpointHolder = this.songOrVideoInfoItem.getArray("flexColumns").getObject(1).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text").getArray("runs").getObject(0);
        if (!navigationEndpointHolder.has("navigationEndpoint")) {
            return null;
        }
        String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(navigationEndpointHolder.getObject("navigationEndpoint"));
        if (!Utils.isNullOrEmpty(url)) {
            return url;
        }
        throw new ParsingException("Could not get uploader URL");
    }

    @Override
    public boolean isUploaderVerified() {
        return false;
    }

    @Override
    public String getTextualUploadDate() {
        return null;
    }

    @Override
    public DateWrapper getUploadDate() {
        return null;
    }

    @Override
    public long getViewCount() throws ParsingException {
        if (this.searchType.equals("music_songs")) {
            return -1L;
        }
        String viewCount = this.descriptionElements.getObject(this.descriptionElements.size() - 3).getString("text");
        if (!Utils.isNullOrEmpty(viewCount)) {
            try {
                return Utils.mixedNumberWordToLong(viewCount);
            }
            catch (Parser.RegexException e) {
                return 0L;
            }
        }
        throw new ParsingException("Could not get view count");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.songOrVideoInfoItem.getObject("thumbnail").getObject("musicThumbnailRenderer").getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails", e);
        }
    }
}

