/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonSink;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeMetaInfoHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMixOrPlaylistLockupInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubePlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeShowRendererInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemLockupExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeSearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeSearchExtractor
extends SearchExtractor {
    @Nullable
    private final String searchType;
    private final boolean extractVideoResults;
    private final boolean extractChannelResults;
    private final boolean extractPlaylistResults;
    private JsonObject initialData;

    public YoutubeSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        super(service, linkHandler);
        List<String> contentFilters = linkHandler.getContentFilters();
        this.searchType = Utils.isNullOrEmpty(contentFilters) ? null : contentFilters.get(0);
        this.extractVideoResults = this.searchType == null || "all".equals(this.searchType) || "videos".equals(this.searchType);
        this.extractChannelResults = this.searchType == null || "all".equals(this.searchType) || "channels".equals(this.searchType);
        this.extractPlaylistResults = this.searchType == null || "all".equals(this.searchType) || "playlists".equals(this.searchType);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String query = super.getSearchString();
        Localization localization = this.getExtractorLocalization();
        String params = YoutubeSearchQueryHandlerFactory.getSearchParameter(this.searchType);
        JsonSink jsonBody = YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("query", query);
        if (!Utils.isNullOrEmpty(params)) {
            ((JsonBuilder)jsonBody).value("params", params);
        }
        byte[] body = JsonWriter.string(((JsonBuilder)jsonBody).done()).getBytes(StandardCharsets.UTF_8);
        this.initialData = YoutubeParsingHelper.getJsonPostResponse("search", body, localization);
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        return super.getUrl() + "&gl=" + this.getExtractorContentCountry().getCountryCode();
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() throws ParsingException {
        JsonObject itemSectionRenderer = this.initialData.getObject("contents").getObject("twoColumnSearchResultsRenderer").getObject("primaryContents").getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("itemSectionRenderer");
        JsonObject didYouMeanRenderer = itemSectionRenderer.getArray("contents").getObject(0).getObject("didYouMeanRenderer");
        if (!didYouMeanRenderer.isEmpty()) {
            return JsonUtils.getString(didYouMeanRenderer, "correctedQueryEndpoint.searchEndpoint.query");
        }
        return Objects.requireNonNullElse(YoutubeParsingHelper.getTextFromObject(itemSectionRenderer.getArray("contents").getObject(0).getObject("showingResultsForRenderer").getObject("correctedQuery")), "");
    }

    @Override
    public boolean isCorrectedSearch() {
        JsonObject showingResultsForRenderer = this.initialData.getObject("contents").getObject("twoColumnSearchResultsRenderer").getObject("primaryContents").getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("itemSectionRenderer").getArray("contents").getObject(0).getObject("showingResultsForRenderer");
        return !showingResultsForRenderer.isEmpty();
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() throws ParsingException {
        return YoutubeMetaInfoHelper.getMetaInfo(this.initialData.getObject("contents").getObject("twoColumnSearchResultsRenderer").getObject("primaryContents").getObject("sectionListRenderer").getArray("contents"));
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        JsonArray sections = this.initialData.getObject("contents").getObject("twoColumnSearchResultsRenderer").getObject("primaryContents").getObject("sectionListRenderer").getArray("contents");
        Page nextPage = null;
        for (Object section : sections) {
            JsonObject sectionJsonObject = (JsonObject)section;
            if (sectionJsonObject.has("itemSectionRenderer")) {
                JsonObject itemSectionRenderer = sectionJsonObject.getObject("itemSectionRenderer");
                this.collectStreamsFrom(collector, itemSectionRenderer.getArray("contents"));
                continue;
            }
            if (!sectionJsonObject.has("continuationItemRenderer")) continue;
            nextPage = this.getNextPageFrom(sectionJsonObject.getObject("continuationItemRenderer"));
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, nextPage);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        Localization localization = this.getExtractorLocalization();
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        byte[] json = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("continuation", page.getId())).done()).getBytes(StandardCharsets.UTF_8);
        JsonObject ajaxJson = YoutubeParsingHelper.getJsonPostResponse("search", json, localization);
        JsonArray continuationItems = ajaxJson.getArray("onResponseReceivedCommands").getObject(0).getObject("appendContinuationItemsAction").getArray("continuationItems");
        JsonArray contents = continuationItems.getObject(0).getObject("itemSectionRenderer").getArray("contents");
        this.collectStreamsFrom(collector, contents);
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, this.getNextPageFrom(continuationItems.getObject(1).getObject("continuationItemRenderer")));
    }

    private void collectStreamsFrom(MultiInfoItemsCollector collector, @Nonnull JsonArray contents) throws SearchExtractor.NothingFoundException {
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        for (Object content : contents) {
            JsonObject item = (JsonObject)content;
            if (item.has("backgroundPromoRenderer")) {
                throw new SearchExtractor.NothingFoundException(YoutubeParsingHelper.getTextFromObject(item.getObject("backgroundPromoRenderer").getObject("bodyText")));
            }
            if (item.has("videoRenderer") && this.extractVideoResults) {
                collector.commit(new YoutubeStreamInfoItemExtractor(item.getObject("videoRenderer"), timeAgoParser));
                continue;
            }
            if (item.has("channelRenderer") && this.extractChannelResults) {
                collector.commit(new YoutubeChannelInfoItemExtractor(item.getObject("channelRenderer")));
                continue;
            }
            if (item.has("playlistRenderer") && this.extractPlaylistResults) {
                collector.commit(new YoutubePlaylistInfoItemExtractor(item.getObject("playlistRenderer")));
                continue;
            }
            if (item.has("showRenderer") && this.extractPlaylistResults) {
                collector.commit(new YoutubeShowRendererInfoItemExtractor(item.getObject("showRenderer")));
                continue;
            }
            if (!item.has("lockupViewModel")) continue;
            JsonObject lockupViewModel = item.getObject("lockupViewModel");
            String contentType = lockupViewModel.getString("contentType");
            if (("LOCKUP_CONTENT_TYPE_PLAYLIST".equals(contentType) || "LOCKUP_CONTENT_TYPE_PODCAST".equals(contentType)) && this.extractPlaylistResults) {
                collector.commit(new YoutubeMixOrPlaylistLockupInfoItemExtractor(lockupViewModel));
                continue;
            }
            if (!"LOCKUP_CONTENT_TYPE_VIDEO".equals(contentType) || !this.extractVideoResults) continue;
            collector.commit(new YoutubeStreamInfoItemLockupExtractor(lockupViewModel, timeAgoParser));
        }
    }

    @Nullable
    private Page getNextPageFrom(JsonObject continuationItemRenderer) {
        if (Utils.isNullOrEmpty(continuationItemRenderer)) {
            return null;
        }
        String token = continuationItemRenderer.getObject("continuationEndpoint").getObject("continuationCommand").getString("token");
        String url = "https://www.youtube.com/youtubei/v1/search?prettyPrint=false";
        return new Page("https://www.youtube.com/youtubei/v1/search?prettyPrint=false", token);
    }
}

