/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.InnertubeClientRequestInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeChannelHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemLockupExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

abstract class YoutubeDesktopBaseKioskExtractor
extends KioskExtractor<StreamInfoItem> {
    protected final String browseId;
    protected final String params;
    protected YoutubeChannelHelper.ChannelResponseData responseData;

    protected YoutubeDesktopBaseKioskExtractor(StreamingService streamingService, ListLinkHandler linkHandler, String kioskId, String browseId, String params) {
        super(streamingService, linkHandler, kioskId);
        this.browseId = browseId;
        this.params = params;
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.responseData = YoutubeChannelHelper.getChannelResponse(this.browseId, this.params, this.getExtractorLocalization(), this.getExtractorContentCountry());
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return YoutubeChannelHelper.getChannelName(YoutubeChannelHelper.getChannelHeader(this.responseData.jsonResponse), null, this.responseData.jsonResponse);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        JsonObject tabRendererContent = this.responseData.jsonResponse.getObject("contents").getObject("twoColumnBrowseResultsRenderer").getArray("tabs").getObject(0).getObject("tabRenderer").getObject("content");
        JsonArray tabContents = tabRendererContent.has("sectionListRenderer") ? tabRendererContent.getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("itemSectionRenderer").getArray("contents").getObject(0).getObject("shelfRenderer").getObject("content").getObject("gridRenderer").getArray("items") : (tabRendererContent.has("richGridRenderer") ? tabRendererContent.getObject("richGridRenderer").getArray("contents") : new JsonArray());
        return this.collectStreamItems(tabContents, this.responseData.jsonResponse.getObject("responseContext").getString("visitorData"));
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || page.getBody() == null) {
            throw new IllegalArgumentException("Page is null or doesn't contain a body");
        }
        JsonObject continuationResponse = YoutubeParsingHelper.getJsonPostResponse("browse", page.getBody(), this.getExtractorLocalization());
        JsonArray continuationItems = continuationResponse.getArray("onResponseReceivedActions").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(jsonObject -> jsonObject.has("appendContinuationItemsAction")).map(jsonObject -> jsonObject.getObject("appendContinuationItemsAction")).findFirst().orElse(new JsonObject()).getArray("continuationItems");
        return this.collectStreamItems(continuationItems, page.getId());
    }

    private ListExtractor.InfoItemsPage<StreamInfoItem> collectStreamItems(@Nonnull JsonArray items, @Nullable String visitorData) throws IOException, ExtractionException {
        Page nextPage;
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        if (items.isEmpty()) {
            nextPage = null;
        } else {
            TimeAgoParser timeAgoParser = this.getTimeAgoParser();
            items.streamAsJsonObjects().forEachOrdered(content -> {
                JsonObject lockupViewModel;
                if (content.has("richItemRenderer")) {
                    JsonObject richItem = content.getObject("richItemRenderer").getObject("content");
                    if (richItem.has("videoRenderer")) {
                        collector.commit(new YoutubeStreamInfoItemExtractor(richItem.getObject("videoRenderer"), timeAgoParser));
                    }
                } else if (content.has("gridVideoRenderer")) {
                    collector.commit(new YoutubeStreamInfoItemExtractor(content.getObject("gridVideoRenderer"), timeAgoParser));
                } else if (content.has("lockupViewModel") && "LOCKUP_CONTENT_TYPE_VIDEO".equals((lockupViewModel = content.getObject("lockupViewModel")).getString("contentType"))) {
                    collector.commit(new YoutubeStreamInfoItemLockupExtractor(lockupViewModel, timeAgoParser));
                }
            });
            JsonObject lastContent = items.getObject(items.size() - 1);
            nextPage = lastContent.has("continuationItemRenderer") ? this.getNextPageFrom(lastContent.getObject("continuationItemRenderer"), visitorData) : null;
        }
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, nextPage);
    }

    @Nullable
    private Page getNextPageFrom(@Nullable JsonObject continuation, @Nullable String visitorData) throws IOException, ExtractionException {
        if (Utils.isNullOrEmpty(continuation)) {
            return null;
        }
        JsonObject continuationEndpoint = continuation.getObject("continuationEndpoint");
        String continuationToken = continuationEndpoint.getObject("continuationCommand").getString("token");
        InnertubeClientRequestInfo webClientRequestInfo = InnertubeClientRequestInfo.ofWebClient();
        webClientRequestInfo.clientInfo.clientVersion = YoutubeParsingHelper.getClientVersion();
        webClientRequestInfo.clientInfo.visitorData = visitorData;
        byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareJsonBuilder(this.getExtractorLocalization(), this.getExtractorContentCountry(), webClientRequestInfo, null).value("continuation", continuationToken)).done()).getBytes(StandardCharsets.UTF_8);
        return new Page("https://www.youtube.com/youtubei/v1/browse?prettyPrint=false", visitorData, null, null, body);
    }
}

