/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.Info;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotSupportedException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Frameset;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamSegment;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.SubtitlesStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class StreamInfo
extends Info {
    private StreamType streamType;
    @Nonnull
    private List<Image> thumbnails = List.of();
    private String textualUploadDate;
    private DateWrapper uploadDate;
    private long duration = -1L;
    private int ageLimit;
    private Description description;
    private long viewCount = -1L;
    private long likeCount = -1L;
    private long dislikeCount = -1L;
    private String uploaderName = "";
    private String uploaderUrl = "";
    @Nonnull
    private List<Image> uploaderAvatars = List.of();
    private boolean uploaderVerified = false;
    private long uploaderSubscriberCount = -1L;
    private String subChannelName = "";
    private String subChannelUrl = "";
    @Nonnull
    private List<Image> subChannelAvatars = List.of();
    private List<VideoStream> videoStreams = List.of();
    private List<AudioStream> audioStreams = List.of();
    private List<VideoStream> videoOnlyStreams = List.of();
    private String dashMpdUrl = "";
    private String hlsUrl = "";
    private List<InfoItem> relatedItems = List.of();
    private long startPosition = 0L;
    private List<SubtitlesStream> subtitles = List.of();
    private String host = "";
    private StreamExtractor.Privacy privacy;
    private String category = "";
    private String licence = "";
    private String supportInfo = "";
    private Locale language = null;
    private List<String> tags = List.of();
    private List<StreamSegment> streamSegments = List.of();
    private List<MetaInfo> metaInfo = List.of();
    private boolean shortFormContent = false;
    private List<Frameset> previewFrames = List.of();

    public StreamInfo(int serviceId, String url, String originalUrl, StreamType streamType, String id2, String name, int ageLimit) {
        super(serviceId, id2, url, originalUrl, name);
        this.streamType = streamType;
        this.ageLimit = ageLimit;
    }

    public static StreamInfo getInfo(String url) throws IOException, ExtractionException {
        return StreamInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static StreamInfo getInfo(@Nonnull StreamingService service, String url) throws IOException, ExtractionException {
        return StreamInfo.getInfo(service.getStreamExtractor(url));
    }

    public static StreamInfo getInfo(@Nonnull StreamExtractor extractor) throws ExtractionException, IOException {
        extractor.fetchPage();
        try {
            StreamInfo streamInfo = StreamInfo.extractImportantData(extractor);
            StreamInfo.extractStreams(streamInfo, extractor);
            StreamInfo.extractOptionalData(streamInfo, extractor);
            return streamInfo;
        }
        catch (ExtractionException e) {
            String errorMessage = extractor.getErrorMessage();
            if (Utils.isNullOrEmpty(errorMessage)) {
                throw e;
            }
            throw new ContentNotAvailableException(errorMessage, e);
        }
    }

    @Nonnull
    private static StreamInfo extractImportantData(@Nonnull StreamExtractor extractor) throws ExtractionException {
        String url = extractor.getUrl();
        StreamType streamType = extractor.getStreamType();
        String id2 = extractor.getId();
        String name = extractor.getName();
        int ageLimit = extractor.getAgeLimit();
        if (streamType == StreamType.NONE || Utils.isNullOrEmpty(url) || Utils.isNullOrEmpty(id2) || name == null || ageLimit == -1) {
            throw new ExtractionException("Some important stream information was not given.");
        }
        return new StreamInfo(extractor.getServiceId(), url, extractor.getOriginalUrl(), streamType, id2, name, ageLimit);
    }

    private static void extractStreams(StreamInfo streamInfo, StreamExtractor extractor) throws ExtractionException {
        try {
            streamInfo.setDashMpdUrl(extractor.getDashMpdUrl());
        }
        catch (Exception e) {
            streamInfo.addError(new ExtractionException("Couldn't get DASH manifest", e));
        }
        try {
            streamInfo.setHlsUrl(extractor.getHlsUrl());
        }
        catch (Exception e) {
            streamInfo.addError(new ExtractionException("Couldn't get HLS manifest", e));
        }
        try {
            streamInfo.setAudioStreams(extractor.getAudioStreams());
        }
        catch (ContentNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            streamInfo.addError(new ExtractionException("Couldn't get audio streams", e));
        }
        try {
            streamInfo.setVideoStreams(extractor.getVideoStreams());
        }
        catch (Exception e) {
            streamInfo.addError(new ExtractionException("Couldn't get video streams", e));
        }
        try {
            streamInfo.setVideoOnlyStreams(extractor.getVideoOnlyStreams());
        }
        catch (Exception e) {
            streamInfo.addError(new ExtractionException("Couldn't get video only streams", e));
        }
        if (streamInfo.videoStreams.isEmpty() && streamInfo.audioStreams.isEmpty()) {
            throw new StreamExtractException("Could not get any stream. See error variable to get further details.");
        }
    }

    private static void extractOptionalData(StreamInfo streamInfo, StreamExtractor extractor) {
        try {
            streamInfo.setThumbnails(extractor.getThumbnails());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setDuration(extractor.getLength());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploaderName(extractor.getUploaderName());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploaderUrl(extractor.getUploaderUrl());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploaderAvatars(extractor.getUploaderAvatars());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploaderVerified(extractor.isUploaderVerified());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploaderSubscriberCount(extractor.getUploaderSubscriberCount());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setSubChannelName(extractor.getSubChannelName());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setSubChannelUrl(extractor.getSubChannelUrl());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setSubChannelAvatars(extractor.getSubChannelAvatars());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setDescription(extractor.getDescription());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setViewCount(extractor.getViewCount());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setTextualUploadDate(extractor.getTextualUploadDate());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setUploadDate(extractor.getUploadDate());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setStartPosition(extractor.getTimeStamp());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setLikeCount(extractor.getLikeCount());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setDislikeCount(extractor.getDislikeCount());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setSubtitles(extractor.getSubtitlesDefault());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setHost(extractor.getHost());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setPrivacy(extractor.getPrivacy());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setCategory(extractor.getCategory());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setLicence(extractor.getLicence());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setLanguageInfo(extractor.getLanguageInfo());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setTags(extractor.getTags());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setSupportInfo(extractor.getSupportInfo());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setStreamSegments(extractor.getStreamSegments());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setMetaInfo(extractor.getMetaInfo());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setPreviewFrames(extractor.getFrames());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        try {
            streamInfo.setShortFormContent(extractor.isShortFormContent());
        }
        catch (Exception e) {
            streamInfo.addError(e);
        }
        streamInfo.setRelatedItems(ExtractorHelper.getRelatedItemsOrLogError(streamInfo, extractor));
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamType streamType) {
        this.streamType = streamType;
    }

    @Nonnull
    public List<Image> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(@Nonnull List<Image> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public String getTextualUploadDate() {
        return this.textualUploadDate;
    }

    public void setTextualUploadDate(String textualUploadDate) {
        this.textualUploadDate = textualUploadDate;
    }

    public DateWrapper getUploadDate() {
        return this.uploadDate;
    }

    public void setUploadDate(DateWrapper uploadDate) {
        this.uploadDate = uploadDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getAgeLimit() {
        return this.ageLimit;
    }

    public void setAgeLimit(int ageLimit) {
        this.ageLimit = ageLimit;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public long getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(long viewCount) {
        this.viewCount = viewCount;
    }

    public long getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(long likeCount) {
        this.likeCount = likeCount;
    }

    public long getDislikeCount() {
        return this.dislikeCount;
    }

    public void setDislikeCount(long dislikeCount) {
        this.dislikeCount = dislikeCount;
    }

    public String getUploaderName() {
        return this.uploaderName;
    }

    public void setUploaderName(String uploaderName) {
        this.uploaderName = uploaderName;
    }

    public String getUploaderUrl() {
        return this.uploaderUrl;
    }

    public void setUploaderUrl(String uploaderUrl) {
        this.uploaderUrl = uploaderUrl;
    }

    @Nonnull
    public List<Image> getUploaderAvatars() {
        return this.uploaderAvatars;
    }

    public void setUploaderAvatars(@Nonnull List<Image> uploaderAvatars) {
        this.uploaderAvatars = uploaderAvatars;
    }

    public boolean isUploaderVerified() {
        return this.uploaderVerified;
    }

    public void setUploaderVerified(boolean uploaderVerified) {
        this.uploaderVerified = uploaderVerified;
    }

    public long getUploaderSubscriberCount() {
        return this.uploaderSubscriberCount;
    }

    public void setUploaderSubscriberCount(long uploaderSubscriberCount) {
        this.uploaderSubscriberCount = uploaderSubscriberCount;
    }

    public String getSubChannelName() {
        return this.subChannelName;
    }

    public void setSubChannelName(String subChannelName) {
        this.subChannelName = subChannelName;
    }

    public String getSubChannelUrl() {
        return this.subChannelUrl;
    }

    public void setSubChannelUrl(String subChannelUrl) {
        this.subChannelUrl = subChannelUrl;
    }

    @Nonnull
    public List<Image> getSubChannelAvatars() {
        return this.subChannelAvatars;
    }

    public void setSubChannelAvatars(@Nonnull List<Image> subChannelAvatars) {
        this.subChannelAvatars = subChannelAvatars;
    }

    public List<VideoStream> getVideoStreams() {
        return this.videoStreams;
    }

    public void setVideoStreams(List<VideoStream> videoStreams) {
        this.videoStreams = videoStreams;
    }

    public List<AudioStream> getAudioStreams() {
        return this.audioStreams;
    }

    public void setAudioStreams(List<AudioStream> audioStreams) {
        this.audioStreams = audioStreams;
    }

    public List<VideoStream> getVideoOnlyStreams() {
        return this.videoOnlyStreams;
    }

    public void setVideoOnlyStreams(List<VideoStream> videoOnlyStreams) {
        this.videoOnlyStreams = videoOnlyStreams;
    }

    public String getDashMpdUrl() {
        return this.dashMpdUrl;
    }

    public void setDashMpdUrl(String dashMpdUrl) {
        this.dashMpdUrl = dashMpdUrl;
    }

    public String getHlsUrl() {
        return this.hlsUrl;
    }

    public void setHlsUrl(String hlsUrl) {
        this.hlsUrl = hlsUrl;
    }

    public List<InfoItem> getRelatedItems() {
        return this.relatedItems;
    }

    @Deprecated
    public List<InfoItem> getRelatedStreams() {
        return this.getRelatedItems();
    }

    public void setRelatedItems(List<InfoItem> relatedItems) {
        this.relatedItems = relatedItems;
    }

    @Deprecated
    public void setRelatedStreams(List<InfoItem> relatedItemsToSet) {
        this.setRelatedItems(relatedItemsToSet);
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    public List<SubtitlesStream> getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(List<SubtitlesStream> subtitles) {
        this.subtitles = subtitles;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public StreamExtractor.Privacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(StreamExtractor.Privacy privacy) {
        this.privacy = privacy;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public Locale getLanguageInfo() {
        return this.language;
    }

    public void setLanguageInfo(Locale locale) {
        this.language = locale;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setSupportInfo(String support) {
        this.supportInfo = support;
    }

    public String getSupportInfo() {
        return this.supportInfo;
    }

    public List<StreamSegment> getStreamSegments() {
        return this.streamSegments;
    }

    public void setStreamSegments(List<StreamSegment> streamSegments) {
        this.streamSegments = streamSegments;
    }

    public void setMetaInfo(List<MetaInfo> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public List<Frameset> getPreviewFrames() {
        return this.previewFrames;
    }

    public void setPreviewFrames(List<Frameset> previewFrames) {
        this.previewFrames = previewFrames;
    }

    @Nonnull
    public List<MetaInfo> getMetaInfo() {
        return this.metaInfo;
    }

    public boolean isShortFormContent() {
        return this.shortFormContent;
    }

    public void setShortFormContent(boolean isShortFormContent) {
        this.shortFormContent = isShortFormContent;
    }

    public static class StreamExtractException
    extends ExtractionException {
        StreamExtractException(String message) {
            super(message);
        }
    }
}

