/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.timeago;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PatternsHolder {
    private final String wordSeparator;
    private final Collection<String> seconds;
    private final Collection<String> minutes;
    private final Collection<String> hours;
    private final Collection<String> days;
    private final Collection<String> weeks;
    private final Collection<String> months;
    private final Collection<String> years;
    private final Map<ChronoUnit, Map<String, Integer>> specialCases = new EnumMap<ChronoUnit, Map<String, Integer>>(ChronoUnit.class);

    protected PatternsHolder(String wordSeparator, Collection<String> seconds, Collection<String> minutes, Collection<String> hours, Collection<String> days, Collection<String> weeks, Collection<String> months, Collection<String> years) {
        this.wordSeparator = wordSeparator;
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.weeks = weeks;
        this.months = months;
        this.years = years;
    }

    protected PatternsHolder(String wordSeparator, String[] seconds, String[] minutes, String[] hours, String[] days, String[] weeks, String[] months, String[] years) {
        this(wordSeparator, Arrays.asList(seconds), Arrays.asList(minutes), Arrays.asList(hours), Arrays.asList(days), Arrays.asList(weeks), Arrays.asList(months), Arrays.asList(years));
    }

    public String wordSeparator() {
        return this.wordSeparator;
    }

    public Collection<String> seconds() {
        return this.seconds;
    }

    public Collection<String> minutes() {
        return this.minutes;
    }

    public Collection<String> hours() {
        return this.hours;
    }

    public Collection<String> days() {
        return this.days;
    }

    public Collection<String> weeks() {
        return this.weeks;
    }

    public Collection<String> months() {
        return this.months;
    }

    public Collection<String> years() {
        return this.years;
    }

    public Map<ChronoUnit, Map<String, Integer>> specialCases() {
        return this.specialCases;
    }

    protected void putSpecialCase(ChronoUnit unit, String caseText, int caseAmount) {
        Map item = this.specialCases.computeIfAbsent(unit, k -> new LinkedHashMap());
        item.put(caseText, caseAmount);
    }

    public Map<ChronoUnit, Collection<String>> asMap() {
        EnumMap<ChronoUnit, Collection<String>> returnMap = new EnumMap<ChronoUnit, Collection<String>>(ChronoUnit.class);
        returnMap.put(ChronoUnit.SECONDS, this.seconds());
        returnMap.put(ChronoUnit.MINUTES, this.minutes());
        returnMap.put(ChronoUnit.HOURS, this.hours());
        returnMap.put(ChronoUnit.DAYS, this.days());
        returnMap.put(ChronoUnit.WEEKS, this.weeks());
        returnMap.put(ChronoUnit.MONTHS, this.months());
        returnMap.put(ChronoUnit.YEARS, this.years());
        return returnMap;
    }
}

