/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public final class Utils {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    private static final Pattern M_PATTERN = Pattern.compile("(https?)?://m\\.");
    private static final Pattern WWW_PATTERN = Pattern.compile("(https?)?://www\\.");

    private Utils() {
    }

    public static String encodeUrlUtf8(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String decodeUrlUtf8(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static String removeNonDigitCharacters(@Nonnull String toRemove) {
        return toRemove.replaceAll("\\D+", "");
    }

    public static long mixedNumberWordToLong(String numberWord) throws NumberFormatException, ParsingException {
        String multiplier = "";
        try {
            multiplier = Parser.matchGroup("[\\d]+([\\.,][\\d]+)?([KMBkmb])+", numberWord, 2);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        double count = Double.parseDouble(Parser.matchGroup1("([\\d]+([\\.,][\\d]+)?)", numberWord).replace(",", "."));
        switch (multiplier.toUpperCase()) {
            case "K": {
                return (long)(count * 1000.0);
            }
            case "M": {
                return (long)(count * 1000000.0);
            }
            case "B": {
                return (long)(count * 1.0E9);
            }
        }
        return (long)count;
    }

    public static void checkUrl(String pattern, String url) throws ParsingException {
        if (Utils.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("Url can't be null or empty");
        }
        if (!Parser.isMatch(pattern, url.toLowerCase())) {
            throw new ParsingException("Url don't match the pattern");
        }
    }

    public static String replaceHttpWithHttps(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith(HTTP)) {
            return HTTPS + url.substring(HTTP.length());
        }
        return url;
    }

    @Nullable
    public static String getQueryValue(@Nonnull URL url, String parameterName) {
        String urlQuery = url.getQuery();
        if (urlQuery != null) {
            for (String param : urlQuery.split("&")) {
                String[] params = param.split("=", 2);
                String query = Utils.decodeUrlUtf8(params[0]);
                if (!query.equals(parameterName)) continue;
                return Utils.decodeUrlUtf8(params[1]);
            }
        }
        return null;
    }

    @Nonnull
    public static URL stringToURL(String url) throws MalformedURLException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            if (e.getMessage().equals("no protocol: " + url)) {
                return new URL(HTTPS + url);
            }
            throw e;
        }
    }

    public static boolean isHTTP(@Nonnull URL url) {
        String protocol = url.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return false;
        }
        boolean usesDefaultPort = url.getPort() == url.getDefaultPort();
        boolean setsNoPort = url.getPort() == -1;
        return setsNoPort || usesDefaultPort;
    }

    public static String removeMAndWWWFromUrl(String url) {
        if (M_PATTERN.matcher(url).find()) {
            return url.replace("m.", "");
        }
        if (WWW_PATTERN.matcher(url).find()) {
            return url.replace("www.", "");
        }
        return url;
    }

    @Nonnull
    public static String removeUTF8BOM(@Nonnull String s) {
        String result = s;
        if (result.startsWith("\ufeff")) {
            result = result.substring(1);
        }
        if (result.endsWith("\ufeff")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Nonnull
    public static String getBaseUrl(String url) throws ParsingException {
        try {
            URL uri = Utils.stringToURL(url);
            return uri.getProtocol() + "://" + uri.getAuthority();
        }
        catch (MalformedURLException e) {
            String message = e.getMessage();
            if (message.startsWith("unknown protocol: ")) {
                return message.substring("unknown protocol: ".length());
            }
            throw new ParsingException("Malformed url: " + url, e);
        }
    }

    public static String followGoogleRedirectIfNeeded(String url) {
        try {
            URL decoded = Utils.stringToURL(url);
            if (decoded.getHost().contains("google") && decoded.getPath().equals("/url")) {
                return Utils.decodeUrlUtf8(Parser.matchGroup1("&url=([^&]+)(?:&|$)", url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isBlank(String string) {
        return string == null || string.isBlank();
    }

    @Nonnull
    public static String join(String delimiter, String mapJoin, @Nonnull Map<? extends CharSequence, ? extends CharSequence> elements) {
        return elements.entrySet().stream().map(entry -> entry.getKey() + mapJoin + entry.getValue()).collect(Collectors.joining(delimiter));
    }

    @Nonnull
    public static String nonEmptyAndNullJoin(CharSequence delimiter, String ... elements) {
        return Arrays.stream(elements).filter(s -> !Utils.isNullOrEmpty(s) && !s.equals("null")).collect(Collectors.joining(delimiter));
    }

    @Nonnull
    public static String getStringResultFromRegexArray(@Nonnull String input, @Nonnull String[] regexes) throws Parser.RegexException {
        return Utils.getStringResultFromRegexArray(input, regexes, 0);
    }

    @Nonnull
    public static String getStringResultFromRegexArray(@Nonnull String input, @Nonnull Pattern[] regexes) throws Parser.RegexException {
        return Utils.getStringResultFromRegexArray(input, regexes, 0);
    }

    @Nonnull
    public static String getStringResultFromRegexArray(@Nonnull String input, @Nonnull String[] regexes, int group) throws Parser.RegexException {
        return Utils.getStringResultFromRegexArray(input, (Pattern[])Arrays.stream(regexes).filter(Objects::nonNull).map(Pattern::compile).toArray(Pattern[]::new), group);
    }

    @Nonnull
    public static String getStringResultFromRegexArray(@Nonnull String input, @Nonnull Pattern[] regexes, int group) throws Parser.RegexException {
        for (Pattern regex : regexes) {
            try {
                String result = Parser.matchGroup(regex, input, group);
                if (result == null) continue;
                return result;
            }
            catch (Parser.RegexException regexException) {
                // empty catch block
            }
        }
        throw new Parser.RegexException("No regex matched the input on group " + group);
    }
}

