/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.BoarEntity;
import net.satisfy.wildernature.core.entity.animation.BoarAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BoarModel<T extends BoarEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("boar"), "main");
    private final ModelPart boar;
    private final ModelPart head;

    public BoarModel(ModelPart root) {
        this.boar = root.getChild("boar");
        this.head = this.boar.getChild("body").getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition boar = partdefinition.addOrReplaceChild("boar", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = boar.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(0.0f, -14.7393f, -13.0868f, 0.0f, 10.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.2607f, (float)3.0868f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -3.0f, -10.0f, 16.0f, 11.0f, 20.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.7393f, (float)-0.0868f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-5.7393f, (float)-8.0868f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 0).addBox(3.0f, -5.6134f, -4.8137f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(7, 8).addBox(-5.0f, -5.6134f, -4.8137f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 32).addBox(-5.0f, -4.6134f, -1.8137f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(64, 48).addBox(-4.0f, -2.6134f, -5.8137f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7673f, (float)-9.4924f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-7.0f, (float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        PartDefinition right_ear_r1 = right_ear.addOrReplaceChild("right_ear_r1", CubeListBuilder.create().texOffs(64, 64).addBox(-5.9654f, -6.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0231f, (float)7.4403f, (float)-7.4924f, (float)-0.2f, (float)-0.2324f, (float)0.0234f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.0f, (float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.8727f));
        PartDefinition left_ear_r1 = left_ear.addOrReplaceChild("left_ear_r1", CubeListBuilder.create().texOffs(64, 58).addBox(-0.0346f, -6.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0231f, (float)7.4403f, (float)-7.4924f, (float)-0.2f, (float)0.2324f, (float)-0.0234f));
        PartDefinition leg_front_left = boar.addOrReplaceChild("legfrontleft", CubeListBuilder.create().texOffs(39, 50).addBox(-4.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-12.0f, (float)-3.0f));
        PartDefinition leg_back_right = boar.addOrReplaceChild("legbackright", CubeListBuilder.create().texOffs(0, 62).addBox(-14.0f, -2.0f, -2.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-8.0f, (float)9.0f));
        PartDefinition leg_back_left = boar.addOrReplaceChild("legbackleft", CubeListBuilder.create().texOffs(61, 32).addBox(9.0f, -2.0f, -3.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-8.0f, (float)10.0f));
        PartDefinition leg_front_right = boar.addOrReplaceChild("legfrontright", CubeListBuilder.create().texOffs(53, 0).addBox(-2.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-12.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.animate(((BoarEntity)((Object)entity)).idleAnimationState, BoarAnimation.idle, ageInTicks, 1.0f);
        this.animateWalk(BoarAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        if (((BoarEntity)((Object)entity)).isDigging()) {
            AnimationDefinition digAnimation = BoarAnimation.dig;
            this.animate(((BoarEntity)((Object)entity)).idleAnimationState, digAnimation, ageInTicks, 1.0f);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.boar.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.boar;
    }
}

