/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.DogEntity;
import net.satisfy.wildernature.core.entity.animation.DogAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DogModel<T extends DogEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("dog"), "main");
    private final ModelPart root;

    public DogModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = animroot.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -5.0f, -6.0f, 7.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-8.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(27, 0).addBox(-2.0f, -2.01f, -2.5f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)-6.0f));
        PartDefinition ears = head.addOrReplaceChild("ears", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-5.0f, (float)-2.0f));
        PartDefinition ear_left = ears.addOrReplaceChild("ear_left", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.7489f));
        PartDefinition ear_left_r1 = ear_left.addOrReplaceChild("ear_left_r1", CubeListBuilder.create().texOffs(26, 57).addBox(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-0.5f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition ear_right = ears.addOrReplaceChild("ear_right", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.7489f));
        PartDefinition ear_right_r1 = ear_right.addOrReplaceChild("ear_right_r1", CubeListBuilder.create().texOffs(26, 57).mirror().addBox(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-0.5f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition upper_body = animroot.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-7.0f));
        PartDefinition leftFrontLeg = animroot.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 54).mirror().addBox(-1.0f, -1.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)-6.0f, (float)-5.0f));
        PartDefinition rightFrontLeg = animroot.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(0, 54).addBox(-1.0f, -1.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-6.0f, (float)-5.0f));
        PartDefinition body = animroot.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-3.5f, -3.0f, 7.0f, 7.0f, 8.0f, 10.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-7.0f));
        PartDefinition leftHindLeg = animroot.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(13, 54).mirror().addBox(-1.0f, -1.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.3f, (float)-6.0f, (float)7.0f));
        PartDefinition rightHindLeg = animroot.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(13, 54).addBox(-1.0f, -1.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.3f, (float)-6.0f, (float)7.0f));
        PartDefinition tail = animroot.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-11.0f, (float)15.0f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(46, 19).addBox(-1.0f, 2.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition realTail = tail.addOrReplaceChild("realTail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_r2 = realTail.addOrReplaceChild("tail_r2", CubeListBuilder.create().texOffs(46, 10).addBox(-1.0f, 2.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int k) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(DogAnimation.walk, limbSwing, limbSwingAmount, 3.0f, 3.0f);
        this.animate(((DogEntity)entity).idleAnimationState, DogAnimation.idle, ageInTicks, 1.0f);
        this.animate(((DogEntity)entity).sitAnimationState, DogAnimation.sit, ageInTicks, 1.0f);
        this.animate(((DogEntity)entity).howlingAnimationState, DogAnimation.howl, ageInTicks, 1.0f);
        this.animate(((DogEntity)entity).attackAnimationState, DogAnimation.bite, ageInTicks, 1.0f);
    }
}

