/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.FlamingoEntity;
import net.satisfy.wildernature.core.entity.animation.FlamingoAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FlamingoModel<T extends FlamingoEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("flamingo"), "main");
    private final ModelPart root;

    public FlamingoModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.3172f, (float)0.5097f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -6.5f, -6.25f, 7.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0937f, (float)0.8669f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.0178f, (float)3.8536f));
        PartDefinition body_r1 = tail.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(36, 9).addBox(-2.5f, 0.5f, -0.5f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.432f, (float)0.8964f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -4.5f, 1.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(11, 19).addBox(0.0f, 1.0f, 4.5f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-6.5f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -4.5f, 1.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(11, 19).addBox(0.0f, 1.0f, 4.5f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-6.5f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.4641f, (float)-5.9365f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(25, 3).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.1517f, (float)-3.0128f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neck_r2 = neck.addOrReplaceChild("neck_r2", CubeListBuilder.create().texOffs(0, 2).addBox(-1.0f, -5.2396f, 0.1266f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.4397f, (float)-3.5385f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition h_head = neck.addOrReplaceChild("h_head", CubeListBuilder.create().texOffs(35, 0).addBox(-3.0005f, -4.0308f, -4.8927f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(25, 0).addBox(-2.0005f, -2.0308f, -5.8927f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.0005f, -2.0308f, -7.8927f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0005f, (float)-8.4359f, (float)0.3241f));
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(20, 18).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 18).addBox(-0.525f, 5.5f, -0.5f, 1.05f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.0909f, (float)0.8013f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg_lower = rightLeg.addOrReplaceChild("rightLeg_lower", CubeListBuilder.create().texOffs(20, 24).addBox(-0.5f, -0.725f, 0.0f, 1.0f, 4.975f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.25f, (float)0.0f));
        PartDefinition rightFoot = rightLeg_lower.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(8, 18).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.25f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(20, 18).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 18).addBox(-0.525f, 5.5f, -0.5f, 1.05f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)1.0909f, (float)0.8013f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg_lower = leftLeg.addOrReplaceChild("leftLeg_lower", CubeListBuilder.create().texOffs(20, 24).addBox(-0.5f, -0.725f, 0.0f, 1.0f, 4.975f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.25f, (float)0.0f));
        PartDefinition leftFoot = leftLeg_lower.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(8, 18).mirror().addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)4.25f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int k) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((FlamingoEntity)((Object)entity)).idleAnimationState, FlamingoAnimation.idle, ageInTicks, 1.0f);
        this.animateWalk(FlamingoAnimation.walk, limbSwing, limbSwingAmount, 3.0f, 3.0f);
        this.animate(((FlamingoEntity)((Object)entity)).standAnimationState, FlamingoAnimation.pose, ageInTicks, 1.0f);
    }
}

