/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.PelicanEntity;
import net.satisfy.wildernature.core.entity.animation.PelicanAnimation;
import org.jetbrains.annotations.NotNull;

public class PelicanModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("pelican"), "main");
    private final ModelPart root;

    public PelicanModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(17, 1).addBox(-3.0f, -4.0f, -4.0f, 6.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(18, 18).addBox(0.0f, -2.0f, 4.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -9.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)1.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("comb", CubeListBuilder.create().texOffs(1, 30).addBox(-2.0f, 0.0f, -8.0f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-2.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(1, 22).addBox(-2.0f, -0.5f, -8.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.5f, (float)-2.0f));
        body.addOrReplaceChild("wing0", CubeListBuilder.create().texOffs(26, 21).addBox(-1.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("wing1", CubeListBuilder.create().texOffs(26, 21).addBox(0.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(6, 45).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-5.0f, (float)1.0f));
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(6, 45).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(PelicanAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((PelicanEntity)entity).attackAnimationState, PelicanAnimation.attack, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int alpha) {
        this.root.render(matrices, vertexConsumer, light, overlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

