/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.RaccoonEntity;
import net.satisfy.wildernature.core.entity.animation.RaccoonAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RaccoonModel<T extends RaccoonEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("raccoon"), "main");
    private final ModelPart root;

    public RaccoonModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)0.5f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = animroot.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, -5.5f, -3.0f, 8.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-4.0f, -6.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.0f, -6.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 13).addBox(-2.0f, 0.0f, -9.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 24).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition leftHindLeg = animroot.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(8, 30).addBox(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)3.0f));
        PartDefinition rightHindLeg = animroot.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(0, 30).addBox(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)0.0f, (float)3.0f));
        PartDefinition leftFrontLeg = animroot.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(8, 30).addBox(-1.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-4.0f));
        PartDefinition rightFrontLeg = animroot.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(0, 30).addBox(-0.995f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T raccoon, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (((RaccoonEntity)((Object)raccoon)).isRaccoonRunning()) {
            this.animateWalk(RaccoonAnimation.run, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.animateWalk(RaccoonAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        }
        this.animate(((RaccoonEntity)((Object)raccoon)).openDoorState, RaccoonAnimation.opening_door, ageInTicks, 1.0f);
        this.animate(((RaccoonEntity)((Object)raccoon)).washingState, RaccoonAnimation.wash, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

