/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.RedWolfEntity;
import net.satisfy.wildernature.core.entity.animation.RedWolfAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RedWolfModel<T extends RedWolfEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("red_wolf"), "main");
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart root;

    public RedWolfModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)16.0f, (float)8.0f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = animroot.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(26, 33).addBox(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.01f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)-12.0f));
        PartDefinition leftFrontLeg = animroot.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)0.0f, (float)-12.0f));
        PartDefinition rightHindLeg = animroot.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(26, 33).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)-1.0f));
        PartDefinition leftHindLeg = animroot.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)0.0f, (float)-1.0f));
        PartDefinition body = animroot.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -7.0f, -5.0f, 6.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)-6.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-3.0f, -3.0f, -4.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-3.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(28, 27).addBox(-1.0f, 0.0f, -7.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-8.5f, (float)-1.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 0).addBox(-1.0f, 0.0f, -2.25f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(23, 17).addBox(-1.0f, 9.0f, -2.25f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)7.0f, (float)-1.0f));
        PartDefinition real_tail = tail.addOrReplaceChild(REAL_TAIL, CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)12.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T wolf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (((RedWolfEntity)wolf).isSneaking()) {
            this.animateWalk(RedWolfAnimation.sneak, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        } else {
            this.animateWalk(RedWolfAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        }
        this.animate(((RedWolfEntity)wolf).attackState, RedWolfAnimation.attack, ageInTicks);
        this.animate(((RedWolfEntity)wolf).sitAnimationState, RedWolfAnimation.sit, ageInTicks, 1.0f);
    }
}

