/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.TurkeyEntity;
import net.satisfy.wildernature.core.entity.animation.TurkeyAnimation;
import org.jetbrains.annotations.NotNull;

public class TurkeyModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("turkeymodel"), "main");
    private final ModelPart root;

    public TurkeyModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)-0.5f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = animroot.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition tail = animroot.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.4438f, (float)3.5127f));
        PartDefinition tail_trim_r1 = tail.addOrReplaceChild("tail_trim_r1", CubeListBuilder.create().texOffs(27, 0).addBox(-7.5f, -17.5f, 3.0f, 13.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-6.0f, -16.0f, 2.0f, 10.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)7.4438f, (float)-3.0127f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = animroot.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(20, 19).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-0.5f, (float)-2.0f));
        PartDefinition left_wing = animroot.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(20, 19).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-0.5f, (float)-2.0f));
        PartDefinition right_leg = animroot.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(19, 2).addBox(-1.0f, -1.0f, -0.6667f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(4, 2).addBox(-0.5f, 2.0f, 0.3333f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-1, 4).addBox(-1.5f, 4.0f, -1.6667f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)2.0f, (float)-0.8333f));
        PartDefinition left_leg = animroot.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(19, 2).addBox(-1.0f, -1.0f, -0.6667f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(-1, 4).addBox(-1.5f, 4.0f, -1.6667f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(4, 2).addBox(-0.5f, 2.0f, 0.3333f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)2.0f, (float)-0.8333f));
        PartDefinition head = animroot.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(-1.0f, -3.125f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 11).addBox(-2.0f, -7.125f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(6, 23).addBox(-1.0f, -5.125f, -4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(-1.0f, -3.125f, -2.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.875f, (float)-3.0f));
        PartDefinition easteregg = head.addOrReplaceChild("easteregg", CubeListBuilder.create().texOffs(8, 28).addBox(-2.0f, -0.874f, -2.0436f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(8, 33).addBox(-2.0f, -2.624f, -2.0436f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.8126f, (float)-0.035f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        TurkeyEntity turkey = (TurkeyEntity)entity;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(TurkeyAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(turkey.attackAnimationState, TurkeyAnimation.attack, ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int k) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

