/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.client.model.entity.FlamingoModel;
import net.satisfy.wildernature.core.entity.FlamingoEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FlamingoRenderer
extends MobRenderer<FlamingoEntity, FlamingoModel<FlamingoEntity>> {
    private static final ResourceLocation WHITE_TEXTURE = WilderNature.identifier("textures/entity/flamingo_white.png");
    private static final ResourceLocation PINK_TEXTURE = WilderNature.identifier("textures/entity/flamingo_pink.png");
    private static final ResourceLocation RED_TEXTURE = WilderNature.identifier("textures/entity/flamingo_red.png");

    public FlamingoRenderer(EntityRendererProvider.Context context) {
        super(context, new FlamingoModel(context.bakeLayer(FlamingoModel.LAYER_LOCATION)), 0.7f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(FlamingoEntity entity) {
        int textureIndex = entity.getId() % 3;
        return switch (textureIndex) {
            case 0 -> WHITE_TEXTURE;
            case 1 -> RED_TEXTURE;
            default -> PINK_TEXTURE;
        };
    }

    public void render(FlamingoEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.isBaby()) {
            pMatrixStack.scale(0.4f, 0.4f, 0.4f);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

