/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.client.model.entity.MiniSheepModel;
import net.satisfy.wildernature.core.entity.MiniSheepEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MiniSheepRenderer
extends MobRenderer<MiniSheepEntity, MiniSheepModel<MiniSheepEntity>> {
    private static final ResourceLocation SHEARED_TEXTURE = WilderNature.identifier("textures/entity/minisheep_sheared.png");
    private static final ResourceLocation DEFAULT_TEXTURE = WilderNature.identifier("textures/entity/minisheep.png");

    public MiniSheepRenderer(EntityRendererProvider.Context context) {
        super(context, new MiniSheepModel(context.bakeLayer(MiniSheepModel.LAYER_LOCATION)), 0.7f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(MiniSheepEntity entity) {
        return entity.isSheared() ? SHEARED_TEXTURE : DEFAULT_TEXTURE;
    }

    public void render(MiniSheepEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isBaby()) {
            matrixStack.scale(0.4f, 0.4f, 0.4f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }
}

