/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.core.block.WallDecorationBlock;
import net.satisfy.wildernature.core.registry.TagsRegistry;
import net.satisfy.wildernature.core.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class RedWolfTrophyBlock
extends WallDecorationBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.9375, (double)1.0, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.28125, (double)0.5625, (double)0.75, (double)0.65625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.65625, (double)0.8125, (double)0.75, (double)0.90625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.65625, (double)0.8125, (double)0.4375, (double)0.90625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.28125, (double)0.375, (double)0.625, (double)0.46875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, WilderNatureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public RedWolfTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            Vector3d center = new Vector3d((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            double range = 32.0;
            AABB boundingBox = new AABB(center.x - range, center.y - range, center.z - range, center.x + range, center.y + range, center.z + range);
            List<BlockPos> blockPositions = BlockPos.betweenClosedStream((AABB)boundingBox).map(BlockPos::immutable).toList();
            for (BlockPos blockPos : blockPositions) {
                BlockState blockState = world.getBlockState(blockPos);
                if (!blockState.is(TagsRegistry.MAKES_BLOCK_GLOW)) continue;
                AreaEffectCloud effectCloud = new AreaEffectCloud(world, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
                effectCloud.setRadius(0.5f);
                effectCloud.setDuration(600);
                effectCloud.setWaitTime(0);
                effectCloud.setParticle((ParticleOptions)ParticleTypes.GLOW);
                world.addFreshEntity((Entity)effectCloud);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

