/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.block;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.satisfy.wildernature.core.entity.TermiteEntity;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;

public class TermiteBlock
extends Block {
    public TermiteBlock(Block base, BlockBehaviour.Properties properties) {
        super(properties.destroyTime(base.defaultDestroyTime() / 2.0f).explosionResistance(0.75f).randomTicks());
    }

    private TermiteEntity spawnInfestation(ServerLevel level, BlockPos pos) {
        TermiteEntity e = new TermiteEntity((EntityType<? extends Animal>)((EntityType)EntityTypeRegistry.TERMITE.get()), (Level)level);
        e.setHome(pos);
        e.moveTo((double)pos.getX() + 0.4, pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity((Entity)e);
        e.spawnAnim();
        return e;
    }

    private int activeCount(Level level, BlockPos pos) {
        TermiteEntity e;
        AABB box = new AABB(pos).inflate(6.0);
        int c = 0;
        Iterator iterator = level.getEntitiesOfClass(TermiteEntity.class, box).iterator();
        while (iterator.hasNext() && (!pos.equals((Object)(e = (TermiteEntity)((Object)iterator.next())).getHome()) || ++c < 2)) {
        }
        return c;
    }

    private TermiteEntity findNearestHomeTermite(Level level, BlockPos moundPos) {
        AABB box = new AABB(moundPos).inflate(6.0);
        List list = level.getEntitiesOfClass(TermiteEntity.class, box);
        for (TermiteEntity e : list) {
            if (!moundPos.equals((Object)e.getHome())) continue;
            return e;
        }
        return null;
    }

    public static void triggerFromLog(ServerLevel level, BlockPos logPos) {
        BlockPos.betweenClosedStream((BlockPos)logPos.offset(-6, -6, -6), (BlockPos)logPos.offset(6, 6, 6)).forEach(p -> {
            BlockState st = level.getBlockState(p);
            Block patt0$temp = st.getBlock();
            if (patt0$temp instanceof TermiteBlock) {
                TermiteBlock b = (TermiteBlock)patt0$temp;
                TermiteEntity e = b.findNearestHomeTermite((Level)level, (BlockPos)p);
                if (e == null && b.activeCount((Level)level, (BlockPos)p) < 2) {
                    e = b.spawnInfestation(level, (BlockPos)p);
                }
                if (e != null) {
                    e.forceTarget(logPos, 200);
                }
            }
        });
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.activeCount((Level)level, pos) >= 2) {
            return;
        }
        if (level.isDay()) {
            return;
        }
        if (level.isRaining()) {
            return;
        }
        if (random.nextInt(200) == 0) {
            this.spawnInfestation(level, pos);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.isClientSide && level.getGameTime() % 8L == 0L && this.activeCount(level, pos) >= 2) {
            BlockParticleOption dust = new BlockParticleOption(ParticleTypes.FALLING_DUST, state);
            level.addAlwaysVisibleParticle((ParticleOptions)dust, (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.6, (double)pos.getY() + 0.9, (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.6, 0.0, 0.02, 0.0);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level instanceof ServerLevel) {
            RegistryAccess access;
            HolderSet.Named logs;
            ServerLevel server = (ServerLevel)level;
            if (fromPos.closerThan((Vec3i)pos, 7.0) && (logs = (HolderSet.Named)(access = server.registryAccess()).registryOrThrow(Registries.BLOCK).getTag(BlockTags.LOGS).orElse(null)) != null && logs.contains(server.getBlockState(fromPos).getBlockHolder())) {
                TermiteEntity e = this.findNearestHomeTermite((Level)server, pos);
                if (e == null && this.activeCount((Level)server, pos) < 2) {
                    e = this.spawnInfestation(server, pos);
                }
                if (e != null) {
                    e.forceTarget(fromPos, 200);
                }
            }
        }
    }

    public void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
        if (level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) == 0 && level.random.nextFloat() < 0.5f) {
            int numTermites = level.random.nextInt(2) + 3;
            for (int i = 0; i < numTermites; ++i) {
                this.spawnInfestation(level, pos);
            }
        }
    }
}

