/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;

public class BoarEntity
extends Animal {
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF, Items.CHICKEN, Items.BEETROOT, Items.SWEET_BERRIES, Items.POTATO, Items.COOKED_COD, Items.COOKED_SALMON, Items.CARROT});
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int digAnimationTick;
    private DigIntoGrassGoal digintoBlockGoal;
    private boolean isDigging = false;

    public BoarEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    protected void registerGoals() {
        this.digintoBlockGoal = new DigIntoGrassGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT_ON_A_STICK}), false));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)this.digintoBlockGoal);
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void customServerAiStep() {
        this.digAnimationTick = this.digintoBlockGoal.getEatAnimationTick();
        super.customServerAiStep();
    }

    public boolean isDigging() {
        return this.isDigging;
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.isDigging = true;
            this.digAnimationTick = 40;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide && this.digAnimationTick > 0) {
            --this.digAnimationTick;
            if (this.digAnimationTick == 0) {
                this.isDigging = false;
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.BOAR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.BOAR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.BOAR_DEATH.get();
    }

    public BoarEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (BoarEntity)((EntityType)EntityTypeRegistry.BOAR.get()).create((Level)serverLevel);
    }

    public boolean isFood(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public static class DigIntoGrassGoal
    extends Goal {
        private static final int EAT_ANIMATION_TICKS = 40;
        private static final BlockStatePredicate IS_GRASS_BLOCK = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);
        private final Mob mob;
        private final Level level;
        private int eatAnimationTick;

        public DigIntoGrassGoal(Mob mob) {
            this.mob = mob;
            this.level = mob.level();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (this.mob.getRandom().nextInt(this.mob.isBaby() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockPos = this.mob.blockPosition();
            return IS_GRASS_BLOCK.test(this.level.getBlockState(blockPos.below()));
        }

        public void start() {
            this.eatAnimationTick = this.adjustedTickDelay(40);
            this.level.broadcastEntityEvent((Entity)this.mob, (byte)10);
            this.mob.getNavigation().stop();
        }

        public void stop() {
            this.eatAnimationTick = 0;
        }

        public boolean canContinueToUse() {
            return this.eatAnimationTick > 0;
        }

        public int getEatAnimationTick() {
            return this.eatAnimationTick;
        }

        public void tick() {
            BlockPos blockPos;
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == this.adjustedTickDelay(4) && IS_GRASS_BLOCK.test(this.level.getBlockState(blockPos = this.mob.blockPosition().below()))) {
                if (this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    this.level.levelEvent(2001, blockPos, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                    this.level.setBlock(blockPos, Blocks.COARSE_DIRT.defaultBlockState(), 2);
                    this.spawnEatParticlesAndDrops((ServerLevel)this.level, blockPos);
                }
                this.mob.ate();
            }
        }

        private void spawnEatParticlesAndDrops(ServerLevel serverLevel, BlockPos blockPos) {
            BlockState blockState = Blocks.GRASS_BLOCK.defaultBlockState();
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, 10, 0.25, 0.25, 0.25, 0.5);
            Random random = new Random();
            int chance = random.nextInt(100);
            if (chance < 10) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.BROWN_MUSHROOM));
            } else if (chance < 15) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.RED_MUSHROOM));
            } else if (chance < 30) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.HANGING_ROOTS));
            }
        }

        private void spawnItem(ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack) {
            Block.popResource((Level)serverLevel, (BlockPos)blockPos, (ItemStack)itemStack);
        }
    }
}

