/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.core.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.core.entity.ai.RandomAction;
import net.satisfy.wildernature.core.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DogEntity
extends TamableAnimal
implements EntityWithAttackAnimation {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public AnimationState howlingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> HOWLING = SynchedEntityData.defineId(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final double MOVEMENT_SPEED = 0.23;
    private static final double MAX_HEALTH = 12.0;
    private static final double ATTACK_DAMAGE = 3.0;
    private static final float SOUND_VOLUME = 0.3f;

    public DogEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    @Nullable
    public DogEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (DogEntity)((EntityType)EntityTypeRegistry.DOG.get()).create((Level)serverLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new AnimationAttackGoal(this, 1.2f, true, (int)(ServerAnimationDurations.dog_bite * 20.0f), 7));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.15));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.25, 18.0f, 7.0f));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(6, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(7, (Goal)new GoAfterCatGoal(this));
        this.goalSelector.addGoal(7, (Goal)this.createRandomActionGoal());
        this.targetSelector.addGoal(10, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private RandomActionGoal createRandomActionGoal() {
        return new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                DogEntity.this.setHowling(true);
            }

            @Override
            public void onStop() {
                DogEntity.this.setHowling(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public void onTick(int tick) {
                if (tick == 20) {
                    DogEntity.this.level().playSound(null, (Entity)DogEntity.this, (SoundEvent)SoundRegistry.DOG_AMBIENT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.dog_howl * 20.0f);
            }

            @Override
            public float chance() {
                return 0.005f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return DogEntity.this.getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)movementSpeed));
            }
        });
    }

    public void tick() {
        super.tick();
        this.handleSittingState();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void handleSittingState() {
        if (!this.level().isClientSide() && this.isTame() && ((Boolean)this.entityData.get(SITTING)).booleanValue() != this.isOrderedToSit()) {
            this.setOrderedToSit((Boolean)this.entityData.get(SITTING));
        }
    }

    private void setupAnimationStates() {
        this.handleIdleAnimation();
        this.howlingAnimationState.animateWhen(this.isHowling(), this.tickCount);
        this.attackAnimationState.animateWhen(this.isAttacking(), this.tickCount);
        this.sitAnimationState.animateWhen(this.isOrderedToSit(), this.tickCount);
    }

    private void handleIdleAnimation() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    private boolean isHowling() {
        return (Boolean)this.entityData.get(HOWLING);
    }

    public void setHowling(boolean howling) {
        this.entityData.set(HOWLING, (Object)howling);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOWLING, (Object)false);
        builder.define(ATTACKING, (Object)false);
        builder.define(SITTING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sitting", this.isOrderedToSit());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        boolean sitting = compound.getBoolean("Sitting");
        this.setOrderedToSit(false);
        this.setOrderedToSit(sitting);
        this.entityData.set(SITTING, (Object)sitting);
    }

    public void setOrderedToSit(boolean sitting) {
        super.setOrderedToSit(sitting);
        this.entityData.set(SITTING, (Object)sitting);
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(SITTING);
    }

    protected void updateWalkAnimation(float partialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.DOG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DOG_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.3f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BONE);
    }

    public boolean canBeLeashed() {
        return true;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.level().isClientSide()) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || itemstack.is(Items.BONE) && !this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return this.handleServerSideInteraction(player, itemstack, hand);
    }

    private InteractionResult handleServerSideInteraction(Player player, ItemStack itemstack, InteractionHand hand) {
        if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player)) {
                if (itemstack.is(Items.BONE)) {
                    return this.handleHealing();
                }
                return this.handleNonBoneInteraction(player);
            }
        } else if (itemstack.is(Items.BONE)) {
            return this.handleTaming(player, itemstack);
        }
        return super.mobInteract(player, hand);
    }

    private InteractionResult handleHealing() {
        if (this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult handleNonBoneInteraction(Player player) {
        InteractionResult interactionresult = super.mobInteract(player, InteractionHand.MAIN_HAND);
        if (!interactionresult.consumesAction() || this.isBaby()) {
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return InteractionResult.SUCCESS;
        }
        return interactionresult;
    }

    private InteractionResult handleTaming(Player player, ItemStack itemstack) {
        this.usePlayerItem(player, InteractionHand.MAIN_HAND, itemstack);
        if (this.random.nextInt(3) == 0) {
            this.tame(player);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public LivingEntity getTarget_() {
        return this.getTarget();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.distanceToSqr((Entity)target);
    }

    @Override
    public void setAttacking_(boolean b) {
        this.entityData.set(ATTACKING, (Object)b);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.getPosition((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.doHurtTarget((Entity)targetEntity);
    }

    public static class GoAfterCatGoal
    extends Goal {
        private final DogEntity dog;
        private List<Cat> catList;
        private int lastCatUpdate = 0;
        private Cat targetCat;
        private static final int CAT_SEARCH_INTERVAL = 20;
        private static final double CAT_DETECTION_RANGE_SQR = 256.0;

        public GoAfterCatGoal(DogEntity dogEntity) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
            this.dog = dogEntity;
        }

        public boolean canUse() {
            return !this.getNearbyCats().isEmpty();
        }

        public void start() {
            super.start();
            this.updateTargetCat();
        }

        public void tick() {
            super.tick();
            this.updateTargetCat();
            if (this.targetCat != null) {
                this.dog.getNavigation().moveTo((Entity)this.targetCat, 1.5);
            }
        }

        public boolean canContinueToUse() {
            return this.targetCat != null && this.targetCat.isAlive() && this.targetCat.distanceToSqr((Entity)this.dog) <= 256.0;
        }

        public void stop() {
            this.targetCat = null;
        }

        private List<Cat> getNearbyCats() {
            if (this.catList == null || this.dog.tickCount - this.lastCatUpdate >= 20) {
                this.catList = this.dog.level().getNearbyEntities(Cat.class, TargetingConditions.forNonCombat(), (LivingEntity)this.dog, this.dog.getBoundingBox().inflate(16.0));
                this.lastCatUpdate = this.dog.tickCount;
            }
            return this.catList;
        }

        private void updateTargetCat() {
            if (this.targetCat == null || this.targetCat.distanceToSqr((Entity)this.dog) > 256.0) {
                double closestDistance = Double.MAX_VALUE;
                Cat closestCat = null;
                for (Cat cat : this.catList) {
                    double distance = cat.distanceToSqr((Entity)this.dog);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestCat = cat;
                }
                this.targetCat = closestCat;
            }
        }
    }
}

