/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity.ai;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.satisfy.wildernature.core.entity.ai.RandomAction;

public class RandomActionGoal
extends Goal {
    private final RandomAction action;
    int counter;
    public static final AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"random_action_do_not_move"), -1000.0, AttributeModifier.Operation.ADD_VALUE);

    public RandomActionGoal(RandomAction mob) {
        this.action = mob;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean isInterruptable() {
        return this.action.isInterruptable();
    }

    public boolean canUse() {
        float r = new Random().nextFloat();
        return r < this.action.chance() && this.action.isPossible();
    }

    public boolean canContinueToUse() {
        return this.counter > 0 && this.counter < this.action.duration() && this.action.isPossible();
    }

    public void tick() {
        ++this.counter;
        this.action.onTick(this.counter);
    }

    public void start() {
        this.counter = 0;
        this.action.onStart();
        Objects.requireNonNull(this.action.getAttribute((Attribute)Attributes.MOVEMENT_SPEED.value())).addTransientModifier(modifier);
        super.start();
    }

    public void stop() {
        this.action.onStop();
        Objects.requireNonNull(this.action.getAttribute((Attribute)Attributes.MOVEMENT_SPEED.value())).removeModifier(modifier);
        super.stop();
    }
}

