/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.item;

import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.entity.BulletEntity;
import net.satisfy.wildernature.core.item.AmmunitionItem;
import net.satisfy.wildernature.core.item.FlintAmmunitionItem;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlunderBussItem
extends ProjectileWeaponItem {
    private static final int DEFAULT_BONUS_DAMAGE = 0;
    private static final double DEFAULT_DAMAGE_MULTIPLIER = 1.0;
    private static final int DEFAULT_FIRE_DELAY = 30;
    private static final double DEFAULT_INACCURACY = 2.25;
    private static final double DEFAULT_PROJECTILE_SPEED = 4.0;
    private static final int DEFAULT_DURABILITY = 128;
    private static final Ingredient DEFAULT_REPAIR_MATERIAL = Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT});
    private static final Predicate<ItemStack> BULLETS = stack -> stack.getItem() instanceof AmmunitionItem && ((AmmunitionItem)stack.getItem()).hasAmmo((ItemStack)stack);
    private final int bonusDamage;
    private final double damageMultiplier;
    private final int fireDelay;
    private final double inaccuracy;
    private final double projectileSpeed;
    private final boolean ignoreInvulnerability;
    private final Ingredient repairMaterial = DEFAULT_REPAIR_MATERIAL;

    public BlunderBussItem() {
        super(new Item.Properties().durability(128));
        this.bonusDamage = 0;
        this.damageMultiplier = 1.0;
        this.fireDelay = 30;
        this.inaccuracy = 2.25;
        this.projectileSpeed = 4.0;
        this.ignoreInvulnerability = false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack gun = player.getItemInHand(hand);
        ItemStack ammo = player.getProjectile(gun);
        if (!ammo.isEmpty() || player.getAbilities().instabuild) {
            Item item;
            if (ammo.isEmpty()) {
                ammo = new ItemStack((ItemLike)Items.IRON_INGOT);
            }
            if ((item = ammo.getItem()) instanceof AmmunitionItem) {
                AmmunitionItem bulletItem = (AmmunitionItem)item;
                if (!world.isClientSide) {
                    boolean bulletFree = player.getAbilities().instabuild || !this.shouldConsumeAmmo();
                    this.shoot(world, player, ammo, bulletItem);
                    gun.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(player.getItemInHand(hand)));
                    if (!bulletFree) {
                        bulletItem.consume(ammo, player);
                    }
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.BLUNDERBUSS_SHOOT.get(), SoundSource.PLAYERS, 1.0f, world.getRandom().nextFloat() * 5.0f + 1.0f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                player.getCooldowns().addCooldown((Item)this, this.getFireDelay());
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    double particleX = player.getX() + player.getLookAngle().x * 2.5;
                    double particleY = player.getY() + (double)player.getEyeHeight() - 0.3;
                    double particleZ = player.getZ() + player.getLookAngle().z * 1.5;
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMALL_FLAME, particleX, particleY, particleZ, 5, 0.1, 0.1, 0.1, 0.01);
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 10, 0.1, 0.1, 0.1, 0.01);
                    serverWorld.getServer().tell((Runnable)new TickTask(serverWorld.getServer().getTickCount() + 40, () -> world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.BLUNDERBUSS_LOAD.get(), SoundSource.PLAYERS, 0.5f, 1.0f)));
                }
                return InteractionResultHolder.consume((Object)gun);
            }
        } else {
            return InteractionResultHolder.fail((Object)gun);
        }
        return InteractionResultHolder.pass((Object)gun);
    }

    protected void shoot(Level world, Player player, ItemStack ammo, AmmunitionItem bulletItem) {
        if (bulletItem instanceof FlintAmmunitionItem) {
            int pelletCount = 4 + world.getRandom().nextInt(5);
            for (int i = 0; i < pelletCount; ++i) {
                BulletEntity pellet = bulletItem.createProjectile(world, ammo.copy(), (LivingEntity)player);
                float spread = (float)(this.getInaccuracy() * 3.5);
                pellet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, (float)this.getProjectileSpeed() * 0.6f, spread);
                pellet.setDamage((double)(bulletItem.getDamage() + 3) * this.getDamageMultiplier());
                pellet.setIgnoreInvulnerability(true);
                pellet.setLifeTicks(12 + world.getRandom().nextInt(4));
                world.addFreshEntity((Entity)pellet);
            }
        } else {
            BulletEntity shot = bulletItem.createProjectile(world, ammo, (LivingEntity)player);
            shot.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, (float)this.getProjectileSpeed(), (float)this.getInaccuracy());
            shot.setDamage((shot.getDamage() + this.getBonusDamage()) * this.getDamageMultiplier());
            shot.setIgnoreInvulnerability(this.ignoreInvulnerability);
            world.addFreshEntity((Entity)shot);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            double particleX = player.getX() + player.getLookAngle().x * 0.5;
            double particleY = player.getY() + (double)player.getEyeHeight() - 0.1;
            double particleZ = player.getZ() + player.getLookAngle().z * 0.5;
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMALL_FLAME, particleX, particleY, particleZ, 5, 0.1, 0.1, 0.1, 0.01);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 10, 0.1, 0.1, 0.1, 0.01);
        }
    }

    public boolean shouldConsumeAmmo() {
        return true;
    }

    public double getBonusDamage() {
        return this.bonusDamage;
    }

    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public int getFireDelay() {
        return this.fireDelay;
    }

    public double getInaccuracy() {
        return this.inaccuracy;
    }

    public double getProjectileSpeed() {
        return this.projectileSpeed;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return BULLETS;
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    protected void shootProjectile(LivingEntity livingEntity, Projectile projectile, int i, float f, float g, float h, @Nullable LivingEntity livingEntity2) {
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return this.repairMaterial.test(repair) || super.isValidRepairItem(toRepair, repair);
    }
}

