/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.registry.RecipeRegistry;
import net.satisfy.wildernature.core.registry.TagsRegistry;
import net.satisfy.wildernature.core.util.Truffling;
import org.jetbrains.annotations.NotNull;

public class TrufflingRecipe
extends CustomRecipe {
    private final String group;
    private final NonNullList<Ingredient> ingredients;

    public TrufflingRecipe(String group, NonNullList<Ingredient> ingredients) {
        super(CraftingBookCategory.MISC);
        this.group = group;
        this.ingredients = ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput recipeInput) {
        return NonNullList.withSize((int)recipeInput.items().size(), (Object)ItemStack.EMPTY);
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        boolean hasFoodInput = false;
        NonNullList matches = NonNullList.withSize((int)this.ingredients.size(), (Object)false);
        int itemsCount = 0;
        for (int slotIndex = 0; slotIndex < recipeInput.items().size(); ++slotIndex) {
            ItemStack stackInSlot = recipeInput.getItem(slotIndex);
            if (stackInSlot.isEmpty()) continue;
            ++itemsCount;
            if ((stackInSlot.is(TagsRegistry.CAN_BE_TRUFFLED) || stackInSlot.has(DataComponents.FOOD)) && !hasFoodInput && !Truffling.isTruffled(stackInSlot)) {
                hasFoodInput = true;
            }
            for (int ingredientIndex = 0; ingredientIndex < this.ingredients.size(); ++ingredientIndex) {
                if (!((Ingredient)this.ingredients.get(ingredientIndex)).test(stackInSlot) || ((Boolean)matches.get(ingredientIndex)).booleanValue()) continue;
                matches.set(ingredientIndex, (Object)true);
            }
        }
        return hasFoodInput && matches.stream().allMatch(match -> match) && itemsCount == this.ingredients.size() + 1;
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        for (int index = 0; index < recipeInput.items().size(); ++index) {
            ItemStack itemStack = recipeInput.getItem(index);
            if (!itemStack.is(TagsRegistry.CAN_BE_TRUFFLED) && !itemStack.has(DataComponents.FOOD)) continue;
            ItemStack resultStack = itemStack.copy();
            resultStack.setCount(1);
            return Truffling.setTruffled(resultStack);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 || height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.TRUFFLING.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<TrufflingRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, TrufflingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<TrufflingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapelessRecipe -> shapelessRecipe.group), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for truffling recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for truffling recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.ingredients)).apply((Applicative)instance, TrufflingRecipe::new));

        @NotNull
        public static TrufflingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int i = buffer.readVarInt();
            NonNullList nonNullList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            return new TrufflingRecipe(group, (NonNullList<Ingredient>)nonNullList);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, TrufflingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
        }

        public MapCodec<TrufflingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TrufflingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

