/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.neoforge.core.player.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.satisfy.wildernature.WilderNature;

public class WolfFurChestplateModel<T extends Entity>
extends EntityModel<T> {
    public static final ResourceLocation WOLF_FUR_CHESTPLATE_TEXTURE = WilderNature.identifier("textures/models/armor/fur_cloak.png");
    private final ModelPart chestplate;
    private final ModelPart cape;

    public WolfFurChestplateModel(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.chestplate = root.getChild("chestplate");
        this.cape = this.chestplate.getChild("cape");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition chestplate = part.addOrReplaceChild("chestplate", CubeListBuilder.create().texOffs(0, 0).addBox(-17.0f, -3.5f, -1.0f, 18.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(23, 22).addBox(-12.0f, -4.5f, 5.0f, 8.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(-11.0f, -0.5f, 5.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)2.5f, (float)-2.0f));
        chestplate.addOrReplaceChild("cape", CubeListBuilder.create().texOffs(0, 10).addBox(-6.0f, 0.5f, 0.5f, 12.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-0.5f, (float)3.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            float speed = (float)e.getDeltaMovement().horizontalDistance();
            float falling = e.onGround() ? 0.0f : Mth.clamp((float)((float)(-e.getDeltaMovement().y * (double)0.8f)), (float)0.0f, (float)0.6f);
            float sprint = e.isSprinting() ? 0.25f : 0.0f;
            float thunder = e.level().isThundering() ? 0.35f + e.level().getThunderLevel(0.0f) * 0.65f : 0.0f;
            float base = 0.15f;
            float targetX = base + speed * 0.6f + sprint + falling + thunder;
            float sway = 0.05f + thunder * 0.6f;
            float targetY = Mth.sin((float)(ageInTicks * 0.25f)) * sway;
            float targetZ = Mth.cos((float)(ageInTicks * 0.2f)) * (0.02f + thunder * 0.2f);
            float lerp = 0.25f;
            this.cape.xRot = Mth.lerp((float)lerp, (float)this.cape.xRot, (float)targetX);
            this.cape.yRot = Mth.lerp((float)lerp, (float)this.cape.yRot, (float)targetY);
            this.cape.zRot = Mth.lerp((float)lerp, (float)this.cape.zRot, (float)targetZ);
        }
    }

    public void syncWithHumanoid(HumanoidModel<?> humanoid) {
        this.chestplate.copyFrom(humanoid.body);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.chestplate.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

