/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux;

import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.container.PlowMenu;
import com.jusipat.astikorcartsredux.container.SeedDrillMenu;
import com.jusipat.astikorcartsredux.entity.AnimalCartEntity;
import com.jusipat.astikorcartsredux.entity.HandCartEntity;
import com.jusipat.astikorcartsredux.entity.PlowEntity;
import com.jusipat.astikorcartsredux.entity.PostilionEntity;
import com.jusipat.astikorcartsredux.entity.ReaperEntity;
import com.jusipat.astikorcartsredux.entity.SeedDrillEntity;
import com.jusipat.astikorcartsredux.entity.SupplyCartEntity;
import com.jusipat.astikorcartsredux.entity.ai.goal.AvoidCartGoal;
import com.jusipat.astikorcartsredux.entity.ai.goal.PullCartGoal;
import com.jusipat.astikorcartsredux.entity.ai.goal.RideCartGoal;
import com.jusipat.astikorcartsredux.item.CartItem;
import com.jusipat.astikorcartsredux.network.clientbound.UpdateDrawnPayload;
import com.jusipat.astikorcartsredux.network.serverbound.ActionKeyPayload;
import com.jusipat.astikorcartsredux.network.serverbound.OpenSupplyCartPayload;
import com.jusipat.astikorcartsredux.network.serverbound.RequestCartUpdatePayload;
import com.jusipat.astikorcartsredux.network.serverbound.ToggleSlowPayload;
import com.jusipat.astikorcartsredux.util.GoalAdder;
import com.jusipat.astikorcartsredux.util.NiftyWorld;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

@Mod(value="astikorcartsredux")
public class AstikorCartsRedux {
    public static final String MODID = "astikorcartsredux";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"astikorcartsredux");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"astikorcartsredux");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"astikorcartsredux");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"astikorcartsredux");
    public static final DeferredRegister<ResourceLocation> AC_STATS = DeferredRegister.create((ResourceKey)Registries.CUSTOM_STAT, (String)"astikorcartsredux");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"astikorcartsredux");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"astikorcartsredux");
    private static final List<Runnable> STAT_SETUP = new ArrayList<Runnable>();
    public static final DeferredHolder<ResourceLocation, ResourceLocation> CART_ONE_CM = AstikorCartsRedux.makeACStat("cart_one_cm");
    public static final DeferredItem<Item> WHEEL = ITEMS.registerItem("wheel", Item::new, new Item.Properties());
    private static final TriFunction<WoodType, String, FeatureFlag[], DeferredItem<CartItem>> CART_ITEM_SUPPLIER = (wood, type, flags) -> ITEMS.register(wood.name() + "_" + type, () -> new CartItem((WoodType)wood, (String)type, new Item.Properties().stacksTo(1).requiredFeatures(flags)));
    public static final Map<String, Map<WoodType, DeferredItem<CartItem>>> CARTS = new HashMap<String, Map<WoodType, DeferredItem<CartItem>>>();
    public static final String[] CART_TYPES = new String[]{"supply_cart", "hand_cart", "plow", "seed_drill", "reaper", "animal_cart"};
    public static final WoodType[] VANILLA_WOOD_TYPES = new WoodType[]{WoodType.OAK, WoodType.SPRUCE, WoodType.BIRCH, WoodType.ACACIA, WoodType.CHERRY, WoodType.JUNGLE, WoodType.DARK_OAK, WoodType.CRIMSON, WoodType.WARPED, WoodType.MANGROVE, WoodType.BAMBOO};
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ASTIKORCARTSREDUX_TAB = CREATIVE_MODE_TABS.register("astikorcartsredux_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.astikorcartsredux")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((Item)WHEEL.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)WHEEL.get());
        CARTS.values().forEach(map -> map.values().forEach(cart -> output.accept((ItemLike)cart.get())));
    }).build());
    public static MinecraftServer server;
    public static final Holder<SoundEvent> ATTACH_SOUND;
    public static final Holder<SoundEvent> DETACH_SOUND;
    public static final Holder<SoundEvent> PLACE_SOUND;
    public static final Supplier<EntityType<SupplyCartEntity>> SUPPLY_CART_ENTITY;
    public static final Supplier<EntityType<AnimalCartEntity>> ANIMAL_CART_ENTITY;
    public static final Supplier<EntityType<PlowEntity>> PLOW_ENTITY;
    public static final Supplier<EntityType<HandCartEntity>> HAND_CART_ENTITY;
    public static final Supplier<EntityType<SeedDrillEntity>> SEED_DRILL_ENTITY;
    public static final Supplier<EntityType<ReaperEntity>> REAPER_ENTITY;
    public static final Supplier<EntityType<PostilionEntity>> POSTILION_ENTITY;
    public static final GoalAdder<Mob> MOB_GOAL_ADDER;
    public static final GoalAdder<PathfinderMob> PATHFINDER_GOAL_ADDER;
    public static final Supplier<MenuType<PlowMenu>> PLOW_MENU_TYPE;
    public static final Supplier<MenuType<SeedDrillMenu>> SEED_DRILL_MENU_TYPE;
    public static final TagKey<Block> PLOW_BREAKABLE_HOE;
    public static final TagKey<Block> PLOW_BREAKABLE_SHOVEL;
    public static final TagKey<Block> PLOW_BREAKABLE_AXE;
    public static final TagKey<Item> SEED_DRILL_PLANTABLE;

    private static DeferredHolder<ResourceLocation, ResourceLocation> makeACStat(String key) {
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)MODID, (String)key);
        STAT_SETUP.add(() -> Stats.CUSTOM.get((Object)resourcelocation, StatFormatter.DEFAULT));
        return AC_STATS.register(key, () -> resourcelocation);
    }

    public AstikorCartsRedux(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerPayloads);
        NeoForge.EVENT_BUS.addListener(AstikorCartsRedux::onEntityJoinWorld);
        NeoForge.EVENT_BUS.addListener(AstikorCartsRedux::onServerTick);
        NeoForge.EVENT_BUS.addListener(AstikorCartsRedux::onEntityInteract);
        NeoForge.EVENT_BUS.addListener(AstikorCartsRedux::onServerStarted);
        NeoForge.EVENT_BUS.addListener(AstikorCartsRedux::onServerStopped);
        modEventBus.addListener(e -> e.put(POSTILION_ENTITY.get(), LivingEntity.createLivingAttributes().build()));
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MENUS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        AC_STATS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AstikorCartsReduxConfig.spec());
    }

    public static <T extends Entity> Supplier<EntityType<T>> register(String id, Supplier<EntityType<T>> supplier) {
        return ENTITY_TYPES.register(id, supplier);
    }

    public static <I extends Item> DeferredItem<I> register(String id, Function<Item.Properties, I> function) {
        return ITEMS.register(id, () -> (Item)function.apply(new Item.Properties()));
    }

    public static ResourceLocation resLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        event.enqueueWork(() -> STAT_SETUP.forEach(Runnable::run));
    }

    private static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        LivingEntity rider = entity.getControllingPassenger();
        if (rider instanceof PostilionEntity) {
            rider.stopRiding();
        }
        event.setCancellationResult(InteractionResult.PASS);
    }

    private static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        MOB_GOAL_ADDER.onEntityJoinWorld(entity);
        PATHFINDER_GOAL_ADDER.onEntityJoinWorld(entity);
    }

    private static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        for (ResourceKey levelKey : server.levelKeys()) {
            NiftyWorld.getServer(server, (ResourceKey<Level>)levelKey).tick();
        }
    }

    private static void onServerStarted(ServerStartedEvent event) {
        server = event.getServer();
    }

    private static void onServerStopped(ServerStoppedEvent event) {
        server = null;
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(WHEEL);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            CARTS.values().forEach(byWood -> Arrays.stream(VANILLA_WOOD_TYPES).forEach(woodType -> event.accept((ItemLike)byWood.get(woodType))));
        }
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(UpdateDrawnPayload.TYPE, UpdateDrawnPayload.CODEC, (payload, context) -> UpdateDrawnPayload.handle(payload, context.player().level()));
        registrar.playToServer(ActionKeyPayload.TYPE, ActionKeyPayload.CODEC, (payload, context) -> ActionKeyPayload.handle(context));
        registrar.playToServer(OpenSupplyCartPayload.TYPE, OpenSupplyCartPayload.CODEC, (payload, context) -> OpenSupplyCartPayload.handle(context));
        registrar.playToServer(ToggleSlowPayload.TYPE, ToggleSlowPayload.CODEC, (payload, context) -> ToggleSlowPayload.handle(context.player()));
        registrar.playToServer(RequestCartUpdatePayload.TYPE, RequestCartUpdatePayload.CODEC, RequestCartUpdatePayload::handle);
    }

    static {
        FeatureFlag[] flags2 = new FeatureFlag[]{};
        for (String type2 : CART_TYPES) {
            HashMap<WoodType, DeferredItem> perWoodMap = new HashMap<WoodType, DeferredItem>();
            for (WoodType wood2 : VANILLA_WOOD_TYPES) {
                String registryName = wood2.name() + "_" + type2;
                DeferredItem item = ITEMS.register(registryName, () -> new CartItem(wood2, type2, new Item.Properties().stacksTo(1).requiredFeatures(flags2)));
                perWoodMap.put(wood2, item);
            }
            CARTS.put(type2, perWoodMap);
        }
        server = null;
        ATTACH_SOUND = SOUND_EVENTS.register("entity.cart.attach", SoundEvent::createVariableRangeEvent);
        DETACH_SOUND = SOUND_EVENTS.register("entity.cart.detach", SoundEvent::createVariableRangeEvent);
        PLACE_SOUND = SOUND_EVENTS.register("entity.cart.place", SoundEvent::createVariableRangeEvent);
        SUPPLY_CART_ENTITY = ENTITY_TYPES.register("supply_cart", () -> EntityType.Builder.of(SupplyCartEntity::new, (MobCategory)MobCategory.MISC).sized(1.5f, 1.4f).build("supply_cart"));
        ANIMAL_CART_ENTITY = ENTITY_TYPES.register("animal_cart", () -> EntityType.Builder.of(AnimalCartEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 1.4f).build("animal_cart"));
        PLOW_ENTITY = ENTITY_TYPES.register("plow", () -> EntityType.Builder.of(PlowEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 1.4f).build("plow"));
        HAND_CART_ENTITY = ENTITY_TYPES.register("hand_cart", () -> EntityType.Builder.of(HandCartEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 1.1f).build("hand_cart"));
        SEED_DRILL_ENTITY = ENTITY_TYPES.register("seed_drill", () -> EntityType.Builder.of(SeedDrillEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 1.4f).build("seed_drill"));
        REAPER_ENTITY = ENTITY_TYPES.register("reaper", () -> EntityType.Builder.of(ReaperEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 1.4f).build("reaper"));
        POSTILION_ENTITY = ENTITY_TYPES.register("postilion", () -> EntityType.Builder.of(PostilionEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).noSummon().noSave().build("postilion"));
        MOB_GOAL_ADDER = GoalAdder.mobGoal(Mob.class).add(1, PullCartGoal::new).add(1, RideCartGoal::new).build();
        PATHFINDER_GOAL_ADDER = GoalAdder.mobGoal(PathfinderMob.class).add(3, mob -> new AvoidCartGoal<SupplyCartEntity>((PathfinderMob)mob, SupplyCartEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<PlowEntity>((PathfinderMob)mob, PlowEntity.class, 3.0f, 0.5)).build();
        PLOW_MENU_TYPE = MENUS.register("plow", () -> new MenuType(PlowMenu::new, FeatureFlags.DEFAULT_FLAGS));
        SEED_DRILL_MENU_TYPE = MENUS.register("seed_drill", () -> new MenuType(SeedDrillMenu::new, FeatureFlags.DEFAULT_FLAGS));
        PLOW_BREAKABLE_HOE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)AstikorCartsRedux.resLoc("plow_breakable/hoe"));
        PLOW_BREAKABLE_SHOVEL = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)AstikorCartsRedux.resLoc("plow_breakable/shovel"));
        PLOW_BREAKABLE_AXE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)AstikorCartsRedux.resLoc("plow_breakable/axe"));
        SEED_DRILL_PLANTABLE = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)AstikorCartsRedux.resLoc("seed_drill_plantable"));
    }
}

