/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux;

import com.google.common.collect.ImmutableMap;
import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxClientRuntime;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.client.renderer.AstikorCartsReduxModelLayers;
import com.jusipat.astikorcartsredux.client.renderer.entity.AnimalCartRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.HandCartRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.PlowRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.PostilionRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.ReaperRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.SeedDrillRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.SupplyCartRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.AnimalCartModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.HandCartModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.PlowModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.ReaperModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.SeedDrillModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.SupplyCartModel;
import com.jusipat.astikorcartsredux.client.renderer.texture.AssembledTexture;
import com.jusipat.astikorcartsredux.client.renderer.texture.AssembledTextureFactory;
import com.jusipat.astikorcartsredux.client.renderer.texture.Material;
import com.jusipat.astikorcartsredux.client.screen.PlowScreen;
import com.jusipat.astikorcartsredux.client.screen.SeedDrillScreen;
import com.jusipat.astikorcartsredux.datagen.ModItemModelProvider;
import com.jusipat.astikorcartsredux.datagen.ModRecipeProvider;
import com.jusipat.astikorcartsredux.datagen.lang.DeDeLanguageProvider;
import com.jusipat.astikorcartsredux.datagen.lang.EnUsLanguageProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.spongepowered.asm.mixin.Unique;

@Mod(value="astikorcartsredux", dist={Dist.CLIENT})
@EventBusSubscriber(modid="astikorcartsredux", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class AstikorCartsReduxClient {
    @Unique
    private static final ImmutableMap<WoodType, String> LOG_NAME_OVERRIDE = ImmutableMap.of((Object)WoodType.CRIMSON, (Object)"stem", (Object)WoodType.WARPED, (Object)"stem", (Object)WoodType.BAMBOO, (Object)"block");

    public AstikorCartsReduxClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AstikorCartsReduxConfig.clientSpec());
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(AstikorCartsRedux.PLOW_MENU_TYPE.get(), PlowScreen::new);
        event.register(AstikorCartsRedux.SEED_DRILL_MENU_TYPE.get(), SeedDrillScreen::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(AstikorCartsRedux.SUPPLY_CART_ENTITY.get(), SupplyCartRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.PLOW_ENTITY.get(), PlowRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.ANIMAL_CART_ENTITY.get(), AnimalCartRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.HAND_CART_ENTITY.get(), HandCartRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.SEED_DRILL_ENTITY.get(), SeedDrillRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.REAPER_ENTITY.get(), ReaperRenderer::new);
        event.registerEntityRenderer(AstikorCartsRedux.POSTILION_ENTITY.get(), PostilionRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.PLOW, PlowModel::createLayer);
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.ANIMAL_CART, AnimalCartModel::createLayer);
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.SUPPLY_CART, SupplyCartModel::createLayer);
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.HAND_CART, HandCartModel::createLayer);
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.SEED_DRILL, SeedDrillModel::createLayer);
        event.registerLayerDefinition(AstikorCartsReduxModelLayers.REAPER, ReaperModel::createLayer);
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)AstikorCartsReduxClientRuntime.ACTION_KEY_MAPPING.get());
        event.register((KeyMapping)AstikorCartsReduxClientRuntime.TOGGLE_SLOW_MAPPING.get());
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, "astikorcartsredux", event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new DeDeLanguageProvider(output, "astikorcartsredux", "de_de"));
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLanguageProvider(output, "astikorcartsredux", "en_us"));
    }

    @SubscribeEvent
    public static void onTextureStitchPost(TextureAtlasStitchedEvent event) {
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        AssembledTextureFactory factory = new AssembledTextureFactory();
        Material composterSide = new Material(ResourceLocation.withDefaultNamespace((String)"block/composter_side"), 16).fill(16, 47, 44, 5, Material.R0, -2, 1).fill(16, 54, 38, 5, Material.R0, -2, -6);
        Material composterTop = new Material(ResourceLocation.withDefaultNamespace((String)"block/composter_top"), 16).fill(18, 45, 10, 2, Material.R0, -2, 3).fill(28, 45, 10, 2, Material.R0, 10, 3).fill(18, 52, 8, 2, Material.R0, 0, -4).fill(26, 52, 9, 2, Material.R0, 11, -4);
        Material stone = new Material(ResourceLocation.withDefaultNamespace((String)"block/stone"), 16).fill(62, 55, 2, 9);
        Material dirt = new Material(ResourceLocation.withDefaultNamespace((String)"block/dirt"), 16).fill(0, 45, 16, 17);
        for (WoodType type : AstikorCartsRedux.VANILLA_WOOD_TYPES) {
            String logName = (String)LOG_NAME_OVERRIDE.getOrDefault((Object)type, (Object)"log");
            factory.add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_animal_cart.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 60, 38, Material.R0, 0, 2).fill(0, 28, 20, 33, Material.R90, 4, -2).fill(12, 30, 8, 31, Material.R270, 0, 4)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 21, 60, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone)).add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_plow.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 42, 3, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 0, 54, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone)).add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_seed_drill.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 64, 3, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 0, 64, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(new Material(ResourceLocation.withDefaultNamespace((String)"block/stone"), 16).fill(62, 55, 2, 9).fill(0, 57, 8, 7, Material.R0))).add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_reaper.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 46, 4, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 0, 64, 4, Material.R90).fill(32, 12, 8, 17, Material.R0).fill(46, 60, 8, 4, Material.R90)).add(new Material(ResourceLocation.withDefaultNamespace((String)"block/stone"), 16).fill(62, 55, 2, 9).fill(0, 32, 64, 16))).add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_supply_cart.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 60, 45, Material.R0, 0, 2).fill(0, 27, 60, 8, Material.R0, 0, 1)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 23, 54, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone).add(composterSide).add(composterTop).add(dirt)).add(new AssembledTexture(AstikorCartsRedux.resLoc("textures/entity/" + type.name() + "_hand_cart.png"), 64, 64).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_planks")), 16).fill(0, 0, 52, 43, Material.R0, 0, 2).fill(0, 24, 42, 4, Material.R0, 0, 1)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/stripped_" + type.name() + "_" + logName)), 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(ResourceLocation.withDefaultNamespace((String)("block/" + type.name() + "_" + logName)), 16).fill(0, 20, 46, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone).add(composterSide).add(composterTop).add(dirt));
        }
        factory.bake();
    }
}

