/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.jusipat.astikorcartsredux.client.renderer.AstikorCartsReduxModelLayers;
import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.AnimalCartModel;
import com.jusipat.astikorcartsredux.entity.AnimalCartEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class AnimalCartRenderer
extends DrawnRenderer<AnimalCartEntity, AnimalCartModel> {
    public AnimalCartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new AnimalCartModel(renderManager.bakeLayer(AstikorCartsReduxModelLayers.ANIMAL_CART)));
        this.shadowRadius = 1.0f;
    }

    @Override
    protected void renderContents(AnimalCartEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        if (entity.getBannerColor() != null) {
            stack.pushPose();
            ((AnimalCartModel)this.model).getBody().translateAndRotate(stack);
            stack.translate(0.0, -0.6, 1.56);
            this.renderBanner(entity, stack, source, delta, packedLight, entity.getBannerColor(), entity.getBannerPattern());
            stack.popPose();
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AnimalCartEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)("textures/entity/" + entity.getWoodType().name() + "_animal_cart.png"));
    }
}

