/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.joml.Matrix4f;

public class CargoRenderUtil {
    public static void renderPainting(PaintingVariant painting, PoseStack stack, VertexConsumer buf, int packedLight) {
        PaintingTextureManager uploader = Minecraft.getInstance().getPaintingTextures();
        int width = painting.width() * 16;
        int height = painting.height() * 16;
        TextureAtlasSprite art = uploader.get(painting);
        TextureAtlasSprite back = uploader.getBackSprite();
        Matrix4f model = stack.last().pose();
        PoseStack.Pose pose = stack.last();
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        float offsetX = (float)(-blockWidth) / 2.0f;
        float offsetY = (float)(-blockHeight) / 2.0f;
        float depth = 0.03125f;
        float bu0 = back.getU0();
        float bu1 = back.getU1();
        float bv0 = back.getV0();
        float bv1 = back.getV1();
        float bup = back.getU(0.0625f);
        float bvp = back.getV(0.0625f);
        float uvX = 1.0f / (float)blockWidth;
        float uvY = 1.0f / (float)blockHeight;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                float x1 = offsetX + (float)(x + 1);
                float x0 = offsetX + (float)x;
                float y1 = offsetY + (float)(y + 1);
                float y0 = offsetY + (float)y;
                float u0 = art.getU(uvX * (float)(blockWidth - x));
                float u1 = art.getU(uvX * (float)(blockWidth - x - 1));
                float v0 = art.getV(uvY * (float)(blockHeight - y));
                float v1 = art.getV(uvY * (float)(blockHeight - y - 1));
                CargoRenderUtil.vert(model, pose, buf, x1, y0, u1, v0, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, u0, v0, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, u0, v1, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, u1, v1, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, bu0, bv0, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, bu1, bv0, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, bu1, bv1, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y0, bu0, bv1, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, bu0, bv0, -0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, bu1, bv0, -0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, bu1, bvp, 0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, bu0, bvp, 0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y0, bu0, bv0, 0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, bu1, bv0, 0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, bu1, bvp, -0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y0, bu0, bvp, -0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, bup, bv0, 0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y0, bup, bv1, 0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y0, bu0, bv1, -0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x1, y1, bu0, bv0, -0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, bup, bv0, -0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, bup, bv1, -0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y0, bu0, bv1, 0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, pose, buf, x0, y1, bu0, bv0, 0.03125f, 1, 0, 0, packedLight);
            }
        }
    }

    private static void vert(Matrix4f stack, PoseStack.Pose pose, VertexConsumer buf, float x, float y, float u, float v, float z, int nx, int ny, int nz, int packedLight) {
        buf.addVertex(stack, x, y, z).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)nx, (float)ny, (float)nz);
    }
}

