/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public abstract class DrawnRenderer<T extends AbstractDrawnEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    protected M model;
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;
    private static final Field CHILDREN_FIELD;

    protected DrawnRenderer(EntityRendererProvider.Context renderManager, M model) {
        super(renderManager);
        this.model = model;
        ModelPart banner = renderManager.bakeLayer(ModelLayers.BANNER);
        this.flag = banner.getChild("flag");
        this.pole = banner.getChild("pole");
        this.bar = banner.getChild("bar");
    }

    public void render(T entity, float yaw, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        stack.pushPose();
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        this.setupRotation(entity, info.getYaw(), delta, stack);
        this.model.setupAnim(entity, delta, 0.0f, 0.0f, 0.0f, info.getPitch());
        VertexConsumer buf = source.getBuffer(this.model.renderType(this.getTextureLocation((Entity)entity)));
        this.model.renderToBuffer(stack, buf, packedLight, OverlayTexture.NO_OVERLAY);
        this.renderContents(entity, delta, stack, source, packedLight);
        stack.popPose();
        super.render(entity, info.getYaw(), delta, stack, source, packedLight);
    }

    protected abstract void renderContents(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5);

    public void setupRotation(T entity, float entityYaw, float delta, PoseStack stack) {
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            double center = 1.2;
            stack.translate(0.0, 1.2, 0.0);
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            float angle = Mth.sin((float)time) * time * damage / 60.0f;
            stack.mulPose(Axis.ZP.rotationDegrees(angle * (float)((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
            stack.translate(0.0, -1.2, 0.0);
            stack.translate(0.0, (double)(angle / 32.0f), 0.0);
        }
        stack.scale(-1.0f, -1.0f, 1.0f);
    }

    protected void renderBanner(T entity, PoseStack stack, MultiBufferSource source, float delta, int packedLight, DyeColor color, BannerPatternLayers banner) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        float scale = 0.6666667f;
        stack.scale(0.6666667f, 0.6666667f, 0.6666667f);
        VertexConsumer consumer = ModelBakery.BANNER_BASE.buffer(source, RenderType::entitySolid);
        this.pole.zRot = -0.3f;
        this.pole.x = 14.0f;
        this.pole.render(stack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.bar.x = -4.0f;
        this.bar.y = 4.0f;
        this.bar.z = 0.1f;
        this.bar.render(stack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.flag.x = -4.0f;
        this.flag.y = -26.0f;
        this.flag.z = 1.5f;
        float k = ((float)Math.floorMod((long)(entity.getX() * 7.0 + entity.getY() * 9.0 + entity.getZ() * 13.0) + entity.level().getGameTime(), 100L) + delta) / 100.0f;
        this.flag.xRot = 0.01f * Mth.cos((float)((float)Math.PI * 2 * k)) * (float)Math.PI;
        BannerRenderer.renderPatterns((PoseStack)stack, (MultiBufferSource)source, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)color, (BannerPatternLayers)banner);
        stack.popPose();
    }

    private Map<String, ModelPart> getChildren(ModelPart part) {
        try {
            return (Map)CHILDREN_FIELD.get(part);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void attach(ModelPart bone, ModelPart attachment, Consumer<PoseStack> function, PoseStack stack) {
        stack.pushPose();
        bone.translateAndRotate(stack);
        if (bone == attachment) {
            function.accept(stack);
        } else {
            Map<String, ModelPart> childModels = this.getChildren(bone);
            for (ModelPart child : childModels.values()) {
                this.attach(child, attachment, function, stack);
            }
        }
        stack.popPose();
    }

    static {
        try {
            CHILDREN_FIELD = ModelPart.class.getDeclaredField("children");
            CHILDREN_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

