/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.jusipat.astikorcartsredux.client.renderer.AstikorCartsReduxModelLayers;
import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.PlowModel;
import com.jusipat.astikorcartsredux.entity.PlowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PlowRenderer
extends DrawnRenderer<PlowEntity, PlowModel> {
    public PlowRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new PlowModel(renderManager.bakeLayer(AstikorCartsReduxModelLayers.PLOW)));
        this.shadowRadius = 1.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(PlowEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)("textures/entity/" + entity.getWoodType().name() + "_plow.png"));
    }

    @Override
    protected void renderContents(PlowEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        for (int i = 0; i < entity.getItemStacks().size(); ++i) {
            ItemStack itemStack = entity.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.attach(((PlowModel)this.model).getBody(), ((PlowModel)this.model).getShaft(i), s -> {
                s.mulPose(Axis.XP.rotationDegrees(-90.0f));
                s.mulPose(Axis.YP.rotationDegrees(90.0f));
                s.translate(-0.25, 0.0625, 0.0);
                if (itemStack.getItem() instanceof BlockItem) {
                    s.translate(0.0, -0.1, 0.0);
                    s.mulPose(Axis.ZP.rotationDegrees(180.0f));
                }
                Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, s, source, entity.level(), 0);
            }, stack);
        }
    }
}

