/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.jusipat.astikorcartsredux.entity.PostilionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class PostilionRenderer
extends EntityRenderer<PostilionEntity> {
    public PostilionRenderer(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(PostilionEntity postilion, float yaw, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        if (!postilion.isInvisible()) {
            stack.pushPose();
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
            AABB bounds = postilion.getBoundingBox().move(-postilion.getX(), -postilion.getY(), -postilion.getZ());
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)source.getBuffer(RenderType.lines()), (AABB)bounds, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.popPose();
            super.render((Entity)postilion, yaw, delta, stack, source, packedLight);
        }
    }

    protected boolean shouldShowName(PostilionEntity postilion) {
        return true;
    }

    @Nullable
    public ResourceLocation getTextureLocation(PostilionEntity postilion) {
        return null;
    }
}

