/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.client.renderer.AstikorCartsReduxModelLayers;
import com.jusipat.astikorcartsredux.client.renderer.entity.CargoRenderUtil;
import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.SupplyCartModel;
import com.jusipat.astikorcartsredux.entity.SupplyCartEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class SupplyCartRenderer
extends DrawnRenderer<SupplyCartEntity, SupplyCartModel> {
    private final HumanoidModel<LivingEntity> leggings;
    private final HumanoidModel<LivingEntity> armor;
    private final TextureAtlas armorTrimAtlas;

    public SupplyCartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new SupplyCartModel(renderManager.bakeLayer(AstikorCartsReduxModelLayers.SUPPLY_CART)));
        this.leggings = new HumanoidModel(renderManager.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.armor = new HumanoidModel(renderManager.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR));
        this.shadowRadius = 1.0f;
        this.armorTrimAtlas = renderManager.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    }

    @Override
    protected void renderContents(SupplyCartEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        ItemStack s;
        NonNullList<ItemStack> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.isEmpty()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((ItemStack)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.isEmpty() || contents.predicate.test((ItemStack)s)) continue;
            contents = Contents.SUPPLIES;
            if (contents.predicate.test((ItemStack)s)) continue;
            contents = Contents.NONE;
        }
        stack.pushPose();
        ((SupplyCartModel)this.model).getBody().translateAndRotate(stack);
        if (contents.renderer != null) {
            contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        }
        if (entity.getBannerColor() != null) {
            stack.translate(0.0, -0.6, 1.5);
            this.renderBanner(entity, stack, source, delta, packedLight, entity.getBannerColor(), entity.getBannerPattern());
        }
        stack.popPose();
    }

    private void renderFlowers(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ((SupplyCartModel)this.model).getFlowerBasket().render(stack, source.getBuffer(((SupplyCartModel)this.model).renderType(this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer renderer = dispatcher.getModelRenderer();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (!(itemStack.getItem() instanceof BlockItem)) continue;
            int ix = i % 2;
            int iz = i / 2;
            BlockState defaultState = ((BlockItem)itemStack.getItem()).getBlock().defaultBlockState();
            BlockState state = defaultState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) ? (BlockState)defaultState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER) : defaultState;
            BakedModel model = dispatcher.getBlockModel(state);
            int rgb = Minecraft.getInstance().getBlockColors().getColor(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.pushPose();
            stack.translate(0.0, -0.7, -0.1875);
            stack.scale(0.65f, 0.65f, 0.65f);
            stack.translate((double)ix, 0.5, (double)iz - 1.0);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            renderer.renderModel(stack.last(), source.getBuffer(RenderType.cutout()), state, model, r, g, b, packedLight, OverlayTexture.NO_OVERLAY);
            stack.popPose();
        }
    }

    private void renderWheel(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        stack.pushPose();
        stack.translate(1.18, 0.1, -0.15);
        ModelPart wheel = ((SupplyCartModel)this.model).getWheel();
        wheel.xRot = 0.9f;
        wheel.zRot = 0.9424779f;
        wheel.render(stack, source.getBuffer(((SupplyCartModel)this.model).renderType(this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    private void renderPaintings(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        VertexConsumer buf = source.getBuffer(RenderType.entitySolid((ResourceLocation)Minecraft.getInstance().getPaintingTextures().getBackSprite().atlasLocation()));
        Random rng = new Random(entity.getUUID().getMostSignificantBits() ^ entity.getUUID().getLeastSignificantBits());
        int count = 0;
        for (ItemStack itemStack : cargo) {
            if (itemStack.isEmpty()) continue;
            ++count;
        }
        stack.pushPose();
        stack.translate(0.0, -0.15625, 0.0);
        stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        RegistryAccess registryAccess = entity.level().registryAccess();
        ObjectArrayList variants = new ObjectArrayList();
        registryAccess.registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(arg_0 -> SupplyCartRenderer.lambda$renderPaintings$0((ObjectList)variants, arg_0));
        ObjectLists.shuffle((ObjectList)variants, (Random)rng);
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.isEmpty()) continue;
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
            Optional<Object> paintingVariant = Optional.empty();
            if (!customData.isEmpty()) {
                paintingVariant = customData.read((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapDecoder)Painting.VARIANT_MAP_CODEC).result().map(Holder::value);
            }
            if (paintingVariant.isEmpty() || ((PaintingVariant)paintingVariant.get()).area() > 1) {
                if (variants.isEmpty()) continue;
                paintingVariant = Optional.of((PaintingVariant)variants.get(i % variants.size()));
            }
            stack.pushPose();
            stack.translate(0.0, ((double)n++ - (double)(count - 1) * 0.5) / (double)count, -0.0625 * (double)i);
            stack.mulPose(Axis.ZP.rotation(rng.nextFloat() * (float)Math.PI));
            CargoRenderUtil.renderPainting((PaintingVariant)paintingVariant.get(), stack, buf, packedLight);
            stack.popPose();
        }
        stack.popPose();
    }

    private void renderSupplies(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.isEmpty()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((ItemStack)cargo.get(i + 2)).is(ItemTags.BEDS) || i >= 2 && ((ItemStack)cargo.get(i - 2)).is(ItemTags.BEDS)) continue;
            double x = ((double)ix - 0.5) * 11.0 / 16.0;
            double z = ((double)iz * 11.0 - 9.0) / 16.0;
            BakedModel model = renderer.getModel(itemStack, entity.level(), null, i);
            stack.pushPose();
            if (model.isGui3d() && itemStack.getItem() != Items.TRIDENT && ((Boolean)AstikorCartsReduxConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                stack.translate(x, -0.46, z);
                stack.scale(0.65f, 0.65f, 0.65f);
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                if (itemStack.getItem() == Items.SHIELD) {
                    stack.scale(1.2f, 1.2f, 1.2f);
                    stack.mulPose(Axis.YP.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                    stack.translate(0.5, 0.8, -0.05);
                    stack.mulPose(Axis.XP.rotationDegrees(-22.5f));
                } else if (iz < 1 && itemStack.is(ItemTags.BEDS)) {
                    stack.translate(0.0, 0.0, 1.0);
                } else if (!model.isCustomRenderer()) {
                    stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                }
                renderer.render(itemStack, ItemDisplayContext.NONE, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem())));
                stack.translate(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (ArmorItem.class.equals(itemStack.getItem().getClass()) && ((Boolean)AstikorCartsReduxConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                    this.renderArmor(stack, source, packedLight, itemStack, ix);
                } else {
                    stack.scale(0.7f, 0.7f, 0.7f);
                    stack.mulPose(Axis.YP.rotation(rng.nextFloat() * (float)Math.PI));
                    stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    int copies = Math.min(itemStack.getCount(), (itemStack.getCount() - 1) / 16 + 2);
                    renderer.render(itemStack, ItemDisplayContext.FIXED, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.pushPose();
                        stack.mulPose(Axis.ZP.rotation(rng.nextFloat() * (float)Math.PI));
                        stack.translate((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.render(itemStack, ItemDisplayContext.FIXED, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
                        stack.popPose();
                    }
                }
            }
            stack.popPose();
        }
    }

    private EquipmentSlot getEquipmentSlotForItem(ItemStack itemStack) {
        Equipable equipable = Equipable.get((ItemStack)itemStack);
        if (equipable != null) {
            return equipable.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }

    private void renderArmor(PoseStack stack, MultiBufferSource source, int packedLight, ItemStack itemStack, int ix) {
        Item item = itemStack.getItem();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        EquipmentSlot slot = this.getEquipmentSlotForItem(itemStack);
        HumanoidModel<LivingEntity> m = slot == EquipmentSlot.LEGS ? this.leggings : this.armor;
        stack.mulPose(Axis.YP.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.setAllVisible(false);
        m.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        m.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        m.crouching = false;
        m.swimAmount = 0.0f;
        m.young = false;
        switch (slot) {
            case HEAD: {
                stack.translate(0.0, 0.1, 0.0);
                m.head.xRot = 0.2f;
                m.hat.copyFrom(m.head);
                m.head.visible = true;
                m.hat.visible = true;
                break;
            }
            case CHEST: {
                stack.translate(0.0, -0.4, -0.15);
                m.leftArm.xRot = -0.15f;
                m.rightArm.xRot = -0.15f;
                m.body.xRot = 0.9f;
                m.body.visible = true;
                m.rightArm.visible = true;
                m.leftArm.visible = true;
                break;
            }
            case LEGS: {
                stack.translate(0.0, -0.7, -0.15);
                m.body.xRot = 0.0f;
                m.rightLeg.xRot = 1.2f;
                m.leftLeg.xRot = 1.2f;
                m.rightLeg.yRot = -0.3f;
                m.leftLeg.yRot = 0.3f;
                m.body.visible = true;
                m.rightLeg.visible = true;
                m.leftLeg.visible = true;
                break;
            }
            case FEET: {
                stack.translate(0.0, -1.15, -0.1);
                m.rightLeg.xRot = 0.0f;
                m.leftLeg.xRot = 0.0f;
                m.rightLeg.yRot = -0.1f;
                m.leftLeg.yRot = 0.0f;
                m.rightLeg.visible = true;
                m.leftLeg.visible = true;
            }
        }
        stack.scale(0.75f, 0.75f, 0.75f);
        ArmorMaterial material = (ArmorMaterial)armorItem.getMaterial().value();
        int rgb = itemStack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-6265536)) : -1;
        boolean usesInnerModel = slot == EquipmentSlot.LEGS;
        for (ArmorMaterial.Layer layer : material.layers()) {
            int k = layer.dyeable() ? rgb : -1;
            VertexConsumer vertexConsumer = source.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)layer.texture(usesInnerModel)));
            m.renderToBuffer(stack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, k);
        }
        ArmorTrim armorTrim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        if (armorTrim != null) {
            TextureAtlasSprite textureAtlasSprite = this.armorTrimAtlas.getSprite(usesInnerModel ? armorTrim.innerTexture(armorItem.getMaterial()) : armorTrim.outerTexture(armorItem.getMaterial()));
            VertexConsumer vertexConsumer = textureAtlasSprite.wrap(source.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal())));
            m.renderToBuffer(stack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, rgb);
        }
        if (itemStack.hasFoil()) {
            m.renderToBuffer(stack, source.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY, rgb);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(SupplyCartEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)("textures/entity/" + entity.getWoodType().name() + "_supply_cart.png"));
    }

    private static /* synthetic */ void lambda$renderPaintings$0(ObjectList variants, Holder variantHolder) {
        if (((PaintingVariant)variantHolder.value()).area() == 1) {
            variants.add((Object)((PaintingVariant)variantHolder.value()));
        }
    }

    private static enum Contents {
        FLOWERS(s -> s.getItem() instanceof BlockItem && s.is(ItemTags.FLOWERS) && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyFlowers.get() != false, SupplyCartRenderer::renderFlowers),
        PAINTINGS(s -> s.getItem() == Items.PAINTING && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyPaintings.get() != false, SupplyCartRenderer::renderPaintings),
        WHEEL(s -> s.getItem() == AstikorCartsRedux.WHEEL.get() && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyWheel.get() != false, SupplyCartRenderer::renderWheel),
        SUPPLIES(s -> (Boolean)AstikorCartsReduxConfig.getClient().renderSupplies.get(), SupplyCartRenderer::renderSupplies),
        NONE(s -> true, null);

        private final Predicate<? super ItemStack> predicate;
        private final ContentsRenderer renderer;

        private Contents(Predicate<? super ItemStack> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }

    @FunctionalInterface
    private static interface ContentsRenderer {
        public void render(SupplyCartRenderer var1, SupplyCartEntity var2, PoseStack var3, MultiBufferSource var4, int var5, NonNullList<ItemStack> var6);
    }
}

