/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.client.renderer.entity.model;

import com.jusipat.astikorcartsredux.client.renderer.entity.model.EasyMeshBuilder;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;

public abstract class CartModel<T extends AbstractDrawnEntity>
extends EntityModel<T> {
    protected final ModelPart body;
    protected final ModelPart leftWheel;
    protected final ModelPart rightWheel;

    protected CartModel(ModelPart root) {
        this.body = root.getChild("body");
        this.leftWheel = root.getChild("leftWheel");
        this.rightWheel = root.getChild("rightWheel");
    }

    public ModelPart getBody() {
        return this.body;
    }

    public ModelPart getWheel() {
        return this.rightWheel;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer buf, int packedLight, int packedOverlay, int k) {
        this.body.render(stack, buf, packedLight, packedOverlay, k);
        this.leftWheel.render(stack, buf, packedLight, packedOverlay, k);
        this.rightWheel.render(stack, buf, packedLight, packedOverlay, k);
    }

    public void setupAnim(T entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        float rot;
        this.body.xRot = (float)Math.toRadians(pitch);
        this.rightWheel.xRot = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(0) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(0) * (double)delta);
        this.leftWheel.xRot = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(1) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(1) * (double)delta);
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f) * 0.5f;
            rot = (float)Math.toRadians(Mth.sin((float)time) * time * damage / 40.0f * (float)(-((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
        } else {
            rot = 0.0f;
        }
        this.rightWheel.zRot = rot;
        this.leftWheel.zRot = rot;
    }

    public static MeshDefinition createDefinition(float rimLength, float axleLength) {
        MeshDefinition def = new MeshDefinition();
        float angle = 0.3926991f;
        float wheelRadius = rimLength / 2.0f / (Mth.sin((float)angle) / Mth.cos((float)angle));
        float f = axleLength / 2.0f + 2.0f;
        EasyMeshBuilder leftWheel = new EasyMeshBuilder("leftWheel", 46, 60);
        leftWheel.setRotationPoint(f, -wheelRadius, 1.0f);
        leftWheel.addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(-2.0f, -rimLength / 2.0f, wheelRadius - 1.0f, 2.0f, rimLength, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(-1.5f, 1.0f, -0.5f, 1.0f, wheelRadius - 2.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(spoke);
        }
        leftWheel.build(def.getRoot());
        EasyMeshBuilder rightWheel = new EasyMeshBuilder("rightWheel", 46, 60);
        rightWheel.setRotationPoint(-f, -wheelRadius, 1.0f);
        rightWheel.addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(0.0f, -rimLength / 2.0f, wheelRadius - 1.0f, 2.0f, rimLength, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(0.5f, 1.0f, -0.5f, 1.0f, wheelRadius - 2.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(spoke);
        }
        rightWheel.build(def.getRoot());
        return def;
    }

    public static EasyMeshBuilder createBody(int rimLength) {
        EasyMeshBuilder body = new EasyMeshBuilder("body");
        float angle = 0.3926991f;
        float wheelRadius = (float)rimLength / 2.0f / (Mth.sin((float)angle) / Mth.cos((float)angle));
        body.setRotationPoint(0.0f, -wheelRadius, 1.0f);
        return body;
    }
}

