/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.container;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlowMenu
extends AbstractContainerMenu {
    public static final int SLOT_COUNT = 3;
    private final Container container;

    public PlowMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(3));
    }

    public PlowMenu(int id, Inventory inventory, Container container) {
        this(AstikorCartsRedux.PLOW_MENU_TYPE.get(), id, inventory, container);
    }

    public PlowMenu(MenuType<?> menuType, int id, Inventory inventory, Container container) {
        super(menuType, id);
        PlowMenu.checkContainerSize((Container)container, (int)3);
        this.container = container;
        container.startOpen(inventory.player);
        this.addSlot(new Slot(container, 0, 57, 24));
        this.addSlot(new Slot(container, 1, 80, 17));
        this.addSlot(new Slot(container, 2, 103, 24));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public Container getContainer() {
        return this.container;
    }
}

