/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.container;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SeedDrillMenu
extends AbstractContainerMenu {
    public static final int SLOT_COUNT = 9;
    private final Container container;

    public SeedDrillMenu(int i, Inventory inv) {
        this(i, inv, (Container)new SimpleContainer(9));
    }

    public SeedDrillMenu(int i, Inventory inv, Container container) {
        this(AstikorCartsRedux.SEED_DRILL_MENU_TYPE.get(), i, inv, container);
    }

    protected SeedDrillMenu(MenuType<?> menuType, int id, Inventory inventory, Container container) {
        super(menuType, id);
        int i;
        SeedDrillMenu.checkContainerSize((Container)container, (int)9);
        this.container = container;
        container.startOpen(inventory.player);
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(this, container, i, 8 + 18 * i, 28){

                public boolean mayPlace(ItemStack itemStack) {
                    return itemStack.is(AstikorCartsRedux.SEED_DRILL_PLANTABLE);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

