/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.datagen;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void buildRecipes(RecipeOutput exporter) {
        ResourceLocation wheelId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)"wheel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AstikorCartsRedux.WHEEL).define(Character.valueOf('p'), ItemTags.PLANKS).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), RecipeProvider.has((ItemLike)Items.STICK)).pattern("sss").pattern("sps").pattern("sss").save(exporter, wheelId);
        WoodType.values().forEach(woodType -> {
            ResourceLocation supplyCartId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_supply_cart"));
            Item supplyCart = (Item)BuiltInRegistries.ITEM.get(supplyCartId);
            Item planks = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(woodType.name() + "_planks")));
            Criterion recipeTrigger = RecipeProvider.inventoryTrigger((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{AstikorCartsRedux.WHEEL}), ItemPredicate.Builder.item().of(new ItemLike[]{planks})});
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)supplyCart).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).define(Character.valueOf('c'), (ItemLike)Blocks.CHEST).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern("pcp").pattern("pcp").pattern("wpw").save(exporter, supplyCartId);
            ResourceLocation animalCartId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_animal_cart"));
            Item animalCart = (Item)BuiltInRegistries.ITEM.get(animalCartId);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)animalCart).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern("ppp").pattern("ppp").pattern("wpw").save(exporter, animalCartId);
            ResourceLocation handCartId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_hand_cart"));
            Item handCart = (Item)BuiltInRegistries.ITEM.get(handCartId);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)handCart).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).define(Character.valueOf('c'), (ItemLike)Blocks.CHEST).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern("pcp").pattern("wpw").save(exporter, handCartId);
            ResourceLocation plowId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_plow"));
            Item plow = (Item)BuiltInRegistries.ITEM.get(plowId);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)plow).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern("sss").pattern("psp").pattern("wpw").save(exporter, plowId);
            ResourceLocation reaperId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_reaper"));
            Item reaper = (Item)BuiltInRegistries.ITEM.get(reaperId);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)reaper).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('l'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(woodType.name() + "_slab")))).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern(" sl").pattern("spp").pattern("iww").save(exporter, reaperId);
            ResourceLocation seedDrillId = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)(woodType.name() + "_seed_drill"));
            Item seedDrill = (Item)BuiltInRegistries.ITEM.get(seedDrillId);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)seedDrill).define(Character.valueOf('p'), (ItemLike)planks).define(Character.valueOf('w'), AstikorCartsRedux.WHEEL).define(Character.valueOf('c'), (ItemLike)Blocks.CHEST).define(Character.valueOf('h'), (ItemLike)Blocks.HOPPER).unlockedBy("has_wheel_and_planks", recipeTrigger).pattern("pcp").pattern("php").pattern("wpw").save(exporter, seedDrillId);
        });
    }
}

