/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.datagen.lang;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.item.CartItem;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredItem;

public class EnUsLanguageProvider
extends LanguageProvider {
    public EnUsLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    private static String capitalizeWordStart(String s) {
        StringBuilder builder = new StringBuilder();
        for (String sub : s.split("_")) {
            builder.append(sub.substring(0, 1).toUpperCase());
            builder.append(sub.substring(1));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String toDisplayName(String input) {
        return Arrays.stream(input.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    protected void addTranslations() {
        this.add((Item)AstikorCartsRedux.WHEEL.get(), "Wheel");
        for (String type : AstikorCartsRedux.CART_TYPES) {
            for (WoodType woodType : WoodType.values().toList()) {
                DeferredItem<CartItem> item = AstikorCartsRedux.CARTS.get(type).get(woodType);
                String displayName = EnUsLanguageProvider.capitalizeWordStart(woodType.name()) + EnUsLanguageProvider.toDisplayName(type);
                this.add((Item)item.get(), displayName);
            }
        }
        this.add(AstikorCartsRedux.SUPPLY_CART_ENTITY.get(), "Supply Cart");
        this.add(AstikorCartsRedux.ANIMAL_CART_ENTITY.get(), "Animal Cart");
        this.add(AstikorCartsRedux.HAND_CART_ENTITY.get(), "Hand Cart");
        this.add(AstikorCartsRedux.PLOW_ENTITY.get(), "Plow");
        this.add(AstikorCartsRedux.SEED_DRILL_ENTITY.get(), "Seed Drill");
        this.add(AstikorCartsRedux.REAPER_ENTITY.get(), "Reaper");
        this.add("stat.astikorcartsredux.cart_one_cm", "Distance by Cart");
        this.add("itemGroup.astikorcartsredux", "AstikorCartsRedux");
        this.add("key.categories.astikorcartsredux", "AstikorCartsRedux");
        this.add("key.astikorcartsredux.action", "Attach/Detach Cart");
        this.add("key.astikorcartsredux.slow", "Toggle Slow");
        this.add("subtitles.astikorcartsredux.cart.attached", "Cart attaches");
        this.add("subtitles.astikorcartsredux.cart.detached", "Cart detaches");
        this.add("subtitles.astikorcartsredux.cart.placed", "Cart placed");
        this.add("tutorial.slow.message", "Press %1$s to toggle slow mode");
        this.add("item.supply_cart.tooltip1", "This cart can hold up to 54 stacks of items");
        this.add("item.supply_cart.tooltip2", "It has one seat and can be decorated with a banner");
        this.add("item.hand_cart.tooltip1", "This cart can hold up to 27 stacks of items");
        this.add("item.hand_cart.tooltip2", "It can only be pulled by the player");
        this.add("item.animal_cart.tooltip1", "This cart has two seats for animals or players and can be decorated with a banner");
        this.add("item.animal_cart.tooltip2", "It can be also controlled from the front seat");
        this.add("item.plow.tooltip1", "This contraption can till the ground, make dirt paths or strip logs");
        this.add("item.plow.tooltip2", "It needs the respective tools to work and can be toggled by right-clicking");
        this.add("item.seed_drill.tooltip1", "This contraption plants seeds on farmland");
        this.add("item.seed_drill.tooltip2", "It has room for 9 stacks of seeds");
        this.add("item.reaper.tooltip1", "This contraption can harvest crops");
        this.add("item.reaper.tooltip2", "Only works if the player is sitting on it");
    }
}

