/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.google.common.collect.ImmutableList;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnInventoryEntity;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractCargoCart
extends AbstractDrawnInventoryEntity {
    private static final ImmutableList<EntityDataAccessor<ItemStack>> CARGO = ImmutableList.of((Object)SynchedEntityData.defineId(AbstractCargoCart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(AbstractCargoCart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(AbstractCargoCart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(AbstractCargoCart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK));

    public AbstractCargoCart(EntityType<? extends Entity> entityTypeIn, Level worldIn, int inventorySize) {
        super(entityTypeIn, worldIn, inventorySize);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        for (EntityDataAccessor parameter : CARGO) {
            builder.define(parameter, (Object)ItemStack.EMPTY);
        }
    }

    public NonNullList<ItemStack> getCargo() {
        NonNullList cargo = NonNullList.withSize((int)CARGO.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < CARGO.size(); ++i) {
            cargo.set(i, (Object)((ItemStack)this.entityData.get((EntityDataAccessor)CARGO.get(i))));
        }
        return cargo;
    }

    @Override
    protected void onContentsChanged(int slot) {
        Object2IntLinkedOpenHashMap totals = new Object2IntLinkedOpenHashMap();
        Object2ObjectOpenHashMap stacks = new Object2ObjectOpenHashMap();
        for (int i = 0; i < this.getItemStacks().size(); ++i) {
            ItemStack stack = (ItemStack)this.getItemStacks().get(i);
            if (stack.isEmpty()) continue;
            totals.mergeInt((Object)stack.getItem(), 1, Integer::sum);
            stacks.putIfAbsent((Object)stack.getItem(), (Object)stack);
        }
        Iterator topTotals = totals.object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> e.getKey() instanceof BlockItem ? 0 : 1).thenComparingInt(e -> -e.getIntValue())).limit(CARGO.size()).iterator();
        Object[] items = new ItemStack[CARGO.size()];
        Arrays.fill(items, ItemStack.EMPTY);
        int forth = this.getItemStacks().size() / CARGO.size();
        int pos = 0;
        while (topTotals.hasNext() && pos < CARGO.size()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)topTotals.next();
            int count = Math.max(1, (entry.getIntValue() + forth / 2) / forth);
            for (int n = 1; n <= count && pos < CARGO.size(); ++n) {
                ItemStack stack = ((ItemStack)stacks.getOrDefault(entry.getKey(), (Object)ItemStack.EMPTY)).copy();
                stack.setCount(Math.min(stack.getMaxStackSize(), entry.getIntValue() / n));
                items[pos++] = stack;
            }
        }
        for (int i = 0; i < CARGO.size(); ++i) {
            this.getEntityData().set((EntityDataAccessor)CARGO.get(i), items[i]);
        }
    }

    @Override
    protected void saveInventory(CompoundTag tag) {
        this.addChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readInventory(CompoundTag tag) {
        this.readChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
    }
}

