/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.network.clientbound.UpdateDrawnPayload;
import com.jusipat.astikorcartsredux.util.CartWheel;
import com.jusipat.astikorcartsredux.util.NiftyWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrawnEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.defineId(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.defineId(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> BANNER = SynchedEntityData.defineId(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<String> WOOD_TYPE = SynchedEntityData.defineId(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final ResourceLocation PULL_SLOWLY_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)"pull_slowly");
    private static final ResourceLocation PULL_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)"pull");
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    protected List<CartWheel> wheels;
    private int pullingId = -1;
    private UUID pullingUUID = null;
    protected double spacing = 1.7;
    public Entity pulling;
    protected AbstractDrawnEntity drawn;

    public AbstractDrawnEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.blocksBuilding = true;
        this.initWheels();
    }

    public float maxUpStep() {
        return 1.2f;
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(3.0, 3.0, 3.0);
    }

    public void tick() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().y - 0.08, 0.0);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.tick();
        this.tickLerp();
        if (this.pulling == null) {
            this.setXRot(25.0f);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.attemptReattach();
        }
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this))) {
            this.push(entity);
        }
    }

    public void pulledTick() {
        if (this.pulling == null) {
            return;
        }
        Vec3 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        if (this.pulling.onGround()) {
            targetVec = new Vec3(targetVec.x, 0.0, targetVec.z);
        }
        double targetVecLength = targetVec.length();
        double r = 0.2;
        double relativeSpacing = Math.max(this.spacing + 0.5 * (double)this.pulling.getBbWidth(), 1.0);
        double diff = targetVecLength - relativeSpacing;
        Vec3 move = Math.abs(diff) < 0.2 ? this.getDeltaMovement() : this.getDeltaMovement().add(targetVec.subtract(targetVec.normalize().scale(relativeSpacing + 0.2 * Math.signum(diff))));
        this.setOnGround(true);
        double startX = this.getX();
        double startY = this.getY();
        double startZ = this.getZ();
        this.move(MoverType.SELF, move);
        if (!this.isAlive()) {
            return;
        }
        this.addStats(this.getX() - startX, this.getY() - startY, this.getZ() - startZ);
        if (this.level().isClientSide) {
            for (CartWheel wheel : this.wheels) {
                wheel.tick();
            }
        } else {
            targetVec = this.getRelativeTargetVec(1.0f);
            if (targetVec.length() > relativeSpacing + 1.0) {
                this.setPulling(null);
            }
        }
        this.updatePassengers();
        if (this.drawn != null) {
            this.drawn.pulledTick();
        }
    }

    private void addStats(double x, double y, double z) {
        int cm;
        if (!this.level().isClientSide && (cm = Math.round(Mth.sqrt((float)((float)(x * x + y * y + z * z))) * 100.0f)) > 0) {
            for (Entity passenger : this.getPassengers()) {
                if (!(passenger instanceof Player)) continue;
                Player player = (Player)passenger;
                player.awardStat((ResourceLocation)AstikorCartsRedux.CART_ONE_CM.get(), cm);
            }
        }
    }

    public void initWheels() {
        this.wheels = Arrays.asList(new CartWheel(this, 0.9f), new CartWheel(this, -0.9f));
    }

    public boolean shouldRemovePulling() {
        if (this.horizontalCollision) {
            Vec3 start = new Vec3(this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ());
            Vec3 end = new Vec3(this.pulling.getX(), this.pulling.getY() + (double)(this.pulling.getBbHeight() / 2.0f), this.pulling.getZ());
            BlockHitResult result = this.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            return result.getType() == HitResult.Type.BLOCK;
        }
        return false;
    }

    public void updatePassengers() {
        for (Entity passenger : this.getPassengers()) {
            this.positionRider(passenger);
        }
    }

    public Entity getPulling() {
        return this.pulling;
    }

    public void setPulling(Entity entityIn) {
        if (!this.level().isClientSide) {
            if (this.canBePulledBy(entityIn)) {
                if (entityIn == null) {
                    if (this.pulling instanceof LivingEntity) {
                        AttributeInstance attr = ((LivingEntity)this.pulling).getAttribute(Attributes.MOVEMENT_SPEED);
                        if (attr != null) {
                            attr.removeModifier(PULL_SLOWLY_MODIFIER_ID);
                            attr.removeModifier(PULL_MODIFIER_ID);
                        }
                    } else if (this.pulling instanceof AbstractDrawnEntity) {
                        ((AbstractDrawnEntity)this.pulling).drawn = null;
                    }
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateDrawnPayload(-1, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.pullingUUID = null;
                    if (this.tickCount > 20) {
                        this.playDetachSound();
                    }
                } else {
                    AttributeInstance attr;
                    if (entityIn instanceof LivingEntity && (Double)this.getConfig().pullSpeed.get() != 0.0 && (attr = ((LivingEntity)entityIn).getAttribute(Attributes.MOVEMENT_SPEED)) != null && attr.getModifier(PULL_MODIFIER_ID) == null) {
                        attr.addTransientModifier(new AttributeModifier(PULL_MODIFIER_ID, ((Double)this.getConfig().pullSpeed.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                    }
                    if (entityIn instanceof PathfinderMob) {
                        PathfinderMob pathfinder = (PathfinderMob)entityIn;
                        pathfinder.getNavigation().stop();
                    }
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateDrawnPayload(entityIn.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.pullingUUID = entityIn.getUUID();
                    if (this.tickCount > 20) {
                        this.playAttachSound();
                    }
                }
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
                this.pulling = entityIn;
                NiftyWorld.get(this.level()).addPulling(this);
            }
        } else {
            if (entityIn == null) {
                this.pullingId = -1;
                for (CartWheel wheel : this.wheels) {
                    wheel.clearIncrement();
                }
                if (this.pulling instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)this.pulling).drawn = null;
                }
            } else {
                this.pullingId = entityIn.getId();
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
            }
            this.pulling = entityIn;
            NiftyWorld.get(this.level()).addPulling(this);
        }
    }

    private void playAttachSound() {
        this.playSound((SoundEvent)AstikorCartsRedux.ATTACH_SOUND.value(), 0.2f, 1.0f);
    }

    private void playDetachSound() {
        this.playSound((SoundEvent)AstikorCartsRedux.DETACH_SOUND.value(), 0.2f, 1.0f);
    }

    private void attemptReattach() {
        Entity entity;
        if (this.level().isClientSide) {
            Entity entity2;
            if (this.pullingId != -1 && (entity2 = this.level().getEntity(this.pullingId)) != null && entity2.isAlive()) {
                this.setPulling(entity2);
            }
        } else if (this.pullingUUID != null && (entity = ((ServerLevel)this.level()).getEntity(this.pullingUUID)) != null && entity.isAlive()) {
            this.setPulling(entity);
        }
    }

    public boolean shouldStopPulledTick() {
        if (!this.isAlive() || this.getPulling() == null || !this.getPulling().isAlive() || this.getPulling().isPassenger()) {
            if (this.pulling != null && this.pulling instanceof Player) {
                this.setPulling(null);
            } else {
                this.pulling = null;
            }
            return true;
        }
        if (!this.level().isClientSide && this.shouldRemovePulling()) {
            this.setPulling(null);
            return true;
        }
        return false;
    }

    public Vec3 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (delta == 1.0f) {
            x = this.pulling.getX() - this.getX();
            y = this.pulling.getY() - this.getY();
            z = this.pulling.getZ() - this.getZ();
        } else {
            x = Mth.lerp((double)delta, (double)this.pulling.xOld, (double)this.pulling.getX()) - Mth.lerp((double)delta, (double)this.xOld, (double)this.getX());
            y = Mth.lerp((double)delta, (double)this.pulling.yOld, (double)this.pulling.getY()) - Mth.lerp((double)delta, (double)this.yOld, (double)this.getY());
            z = Mth.lerp((double)delta, (double)this.pulling.zOld, (double)this.pulling.getZ()) - Mth.lerp((double)delta, (double)this.zOld, (double)this.getZ());
        }
        float yaw = (float)Math.toRadians(this.pulling.getYRot());
        float nx = -Mth.sin((float)yaw);
        float nz = Mth.cos((float)yaw);
        double r = 0.2;
        return new Vec3(x + (double)nx * 0.2, y, z + (double)nz * 0.2);
    }

    public void handleRotation(Vec3 target) {
        this.setYRot(AbstractDrawnEntity.getYaw(target));
        this.setXRot(AbstractDrawnEntity.getPitch(target));
    }

    public static float getYaw(Vec3 vec) {
        return Mth.wrapDegrees((float)((float)Math.toDegrees(-Mth.atan2((double)vec.x, (double)vec.z))));
    }

    public static float getPitch(Vec3 vec) {
        return Mth.wrapDegrees((float)((float)Math.toDegrees(-Mth.atan2((double)vec.y, (double)Mth.sqrt((float)((float)(vec.x * vec.x + vec.z * vec.z)))))));
    }

    public double getWheelRotation(int wheel) {
        return this.wheels.get(wheel).getRotation();
    }

    public double getWheelRotationIncrement(int wheel) {
        return this.wheels.get(wheel).getRotationIncrement();
    }

    public abstract Item getCartItem();

    protected boolean canBePulledBy(Entity entityIn) {
        if (this.level().isClientSide) {
            return true;
        }
        if (entityIn == null) {
            return true;
        }
        return (this.pulling == null || !this.pulling.isAlive()) && !this.hasPassenger(entityIn) && this.canPull(entityIn);
    }

    private boolean canPull(Entity entity) {
        if (entity instanceof Saddleable && !((Saddleable)entity).isSaddleable()) {
            return false;
        }
        if (entity instanceof TamableAnimal && !((TamableAnimal)entity).isTame()) {
            return false;
        }
        ArrayList allowed = (ArrayList)this.getConfig().pullEntities.get();
        if (allowed.isEmpty()) {
            return entity instanceof Player || entity instanceof Saddleable && !(entity instanceof ItemSteerable);
        }
        return allowed.contains(EntityType.getKey((EntityType)entity.getType()).toString());
    }

    protected abstract AstikorCartsReduxConfig.CartConfig getConfig();

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && this.isAlive()) {
            boolean flag;
            if (source.is(DamageTypes.CACTUS)) {
                return false;
            }
            if (source.getEntity() != null && this.hasPassenger(source.getEntity())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.getEntity() instanceof Player && ((Player)source.getEntity()).getAbilities().instabuild;
            if (flag || this.getDamageTaken() > (float)((Integer)this.getConfig().destroyDamage.get() * 10)) {
                this.onDestroyed(source, flag);
                this.setPulling(null);
                this.discard();
            }
            return true;
        }
        return false;
    }

    protected InteractionResult useBanner(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(ItemTags.BANNERS)) {
            ItemStack oldBanner = this.getBanner();
            if (!this.level().isClientSide) {
                ItemStack banner = stack.split(1);
                if (!oldBanner.isEmpty()) {
                    if (stack.isEmpty()) {
                        player.setItemInHand(hand, oldBanner);
                    } else if (!player.getInventory().add(oldBanner)) {
                        player.drop(oldBanner, false);
                    }
                }
                this.playSound(SoundEvents.WOOD_PLACE, 1.0f, 0.8f);
                this.setBanner(banner);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (!byCreativePlayer) {
                this.spawnAtLocation((ItemLike)this.getCartItem());
                this.spawnAtLocation(this.getBanner());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            this.setYRot((float)((double)this.getYRot() + Mth.wrapDegrees((double)(this.lerpYaw - (double)this.getYRot())) / (double)this.lerpSteps));
            this.setXRot((float)((double)this.getXRot() + (this.lerpPitch - (double)this.getXRot()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.setOnGround(true);
            this.move(MoverType.SELF, new Vec3(dx, dy, dz));
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.moveTo(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity first = (Entity)passengers.get(0);
        if (first instanceof Animal || !(first instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)first;
    }

    public boolean isControlledByLocalInstance() {
        return false;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity rider) {
        float[] fArray;
        if (rider.getMainArm() == HumanoidArm.RIGHT) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            Vec3 pos = this.dismount(AbstractDrawnEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)rider.getBbWidth(), (float)(this.getYRot() + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.position();
    }

    private Vec3 dismount(Vec3 dir, LivingEntity rider) {
        double x = this.getX() + dir.x;
        double y = this.getBoundingBox().minY;
        double z = this.getZ() + dir.z;
        double limit = this.getBoundingBox().maxY + 0.75;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : rider.getDismountPoses()) {
            blockPos.set(x, y, z);
            while ((double)blockPos.getY() < limit) {
                double ground = this.level().getBlockFloorHeight((BlockPos)blockPos);
                if ((double)blockPos.getY() + ground > limit) continue block0;
                if (DismountHelper.isBlockFloorValid((double)ground)) {
                    Vec3 pos = new Vec3(x, (double)blockPos.getY() + ground, z);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)rider, (AABB)rider.getLocalBoundsForPose(pose).move(pos))) {
                        rider.setPose(pose);
                        return pos;
                    }
                }
                blockPos.move(Direction.UP);
            }
        }
        return null;
    }

    public void setDamageTaken(float damageTaken) {
        this.entityData.set(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.entityData.get(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.entityData.set(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.entityData.get(FORWARD_DIRECTION);
    }

    public void setBanner(ItemStack banner) {
        this.entityData.set(BANNER, (Object)banner);
    }

    public ItemStack getBanner() {
        return (ItemStack)this.entityData.get(BANNER);
    }

    public void setWoodType(WoodType woodType) {
        this.entityData.set(WOOD_TYPE, (Object)woodType.name());
    }

    public WoodType getWoodType() {
        return WoodType.values().filter(type -> type.name().equals(this.entityData.get(WOOD_TYPE))).findFirst().orElse(null);
    }

    public DyeColor getBannerColor() {
        ItemStack banner = this.getBanner();
        Item item = banner.getItem();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            return bannerItem.getColor();
        }
        return null;
    }

    public BannerPatternLayers getBannerPattern() {
        BannerPatternLayers bannerPatternLayers;
        ItemStack banner = this.getBanner();
        if (banner.getItem() instanceof BannerItem && (bannerPatternLayers = (BannerPatternLayers)banner.get(DataComponents.BANNER_PATTERNS)) != null) {
            return bannerPatternLayers;
        }
        return BannerPatternLayers.EMPTY;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getCartItem());
    }

    public boolean isPickable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(FORWARD_DIRECTION, (Object)1);
        builder.define(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        builder.define(BANNER, (Object)ItemStack.EMPTY);
        builder.define(WOOD_TYPE, (Object)"oak");
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("PullingUUID")) {
            this.pullingUUID = compound.getUUID("PullingUUID");
        }
        if (compound.contains("BannerItem")) {
            this.setBanner(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("BannerItem")));
        }
        String woodTypeString = compound.getString("WoodType");
        WoodType woodType = WoodType.values().filter(type -> type.name().equals(woodTypeString)).findFirst().orElse(WoodType.OAK);
        this.setWoodType(woodType);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        ItemStack banner;
        if (this.pulling != null) {
            compound.putUUID("PullingUUID", this.pullingUUID);
        }
        if (!(banner = this.getBanner()).isEmpty()) {
            compound.put("BannerItem", banner.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        compound.putString("WoodType", this.getWoodType().name());
    }

    public RenderInfo getInfo(float delta) {
        return new RenderInfo(delta);
    }

    public void toggleSlow() {
        Entity pulling = this.pulling;
        if (!(pulling instanceof LivingEntity)) {
            return;
        }
        AttributeInstance speed = ((LivingEntity)pulling).getAttribute(Attributes.MOVEMENT_SPEED);
        if (speed == null) {
            return;
        }
        AttributeModifier modifier = speed.getModifier(PULL_SLOWLY_MODIFIER_ID);
        if (modifier == null) {
            speed.addTransientModifier(new AttributeModifier(PULL_SLOWLY_MODIFIER_ID, ((Double)this.getConfig().slowSpeed.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        } else {
            speed.removeModifier(modifier.id());
        }
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
    }

    protected void playMuffledStepSound(BlockState blockState, BlockPos pos) {
    }

    public class RenderInfo {
        final float delta;
        Vec3 target;
        float yaw = Float.NaN;
        float pitch = Float.NaN;

        public RenderInfo(float delta) {
            this.delta = delta;
        }

        public Vec3 getTarget() {
            if (this.target == null) {
                this.target = AbstractDrawnEntity.this.pulling == null ? AbstractDrawnEntity.this.getViewVector(this.delta) : AbstractDrawnEntity.this.getRelativeTargetVec(this.delta);
            }
            return this.target;
        }

        public float getYaw() {
            if (Float.isNaN(this.yaw)) {
                this.yaw = AbstractDrawnEntity.this.pulling == null ? Mth.lerp((float)this.delta, (float)AbstractDrawnEntity.this.yRotO, (float)AbstractDrawnEntity.this.getYRot()) : AbstractDrawnEntity.getYaw(this.getTarget());
            }
            return this.yaw;
        }

        public float getPitch() {
            if (Float.isNaN(this.pitch)) {
                this.pitch = AbstractDrawnEntity.this.pulling == null ? Mth.lerp((float)this.delta, (float)AbstractDrawnEntity.this.xRotO, (float)AbstractDrawnEntity.this.getXRot()) : AbstractDrawnEntity.getPitch(this.target);
            }
            return this.pitch;
        }
    }
}

