/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.google.common.collect.ImmutableList;
import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.container.PlowMenu;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnInventoryEntity;
import com.jusipat.astikorcartsredux.util.ProxyItemUseContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class PlowEntity
extends AbstractDrawnInventoryEntity {
    private static final int SLOT_COUNT = 3;
    private static final double BLADEOFFSET = 1.7;
    private static final EntityDataAccessor<Boolean> PLOWING = SynchedEntityData.defineId(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ImmutableList<EntityDataAccessor<ItemStack>> TOOLS = ImmutableList.of((Object)SynchedEntityData.defineId(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(PlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK));

    public PlowEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn, 3);
        this.spacing = 1.3;
    }

    @Override
    protected AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().plow;
    }

    public boolean getPlowing() {
        return (Boolean)this.entityData.get(PLOWING);
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.level().isClientSide) {
            Player player = null;
            Entity entity = this.getPulling();
            if (entity instanceof Player) {
                Player pl;
                player = pl = (Player)entity;
            } else {
                entity = this.getPulling().getControllingPassenger();
                if (entity instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity;
                }
            }
            if (((Boolean)this.entityData.get(PLOWING)).booleanValue() && player != null && (this.xo != this.getX() || this.zo != this.getZ())) {
                this.plow(player);
            }
        }
    }

    private void plow(Player player) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!(stack.getItem() instanceof TieredItem)) continue;
            float offset = 38.0f - (float)i * 38.0f;
            double blockPosX = this.getX() + (double)Mth.sin((float)((float)Math.toRadians(this.getYRot() - offset))) * 1.7;
            double blockPosZ = this.getZ() - (double)Mth.cos((float)((float)Math.toRadians(this.getYRot() - offset))) * 1.7;
            BlockPos blockPos = new BlockPos((int)blockPosX, (int)Math.round(this.getY() - 0.75), (int)blockPosZ);
            boolean damageable = stack.isDamageableItem();
            int count = stack.getCount();
            this.tryBreakBlock(stack, blockPos.above(), this.level(), player);
            stack.getItem().useOn((UseOnContext)new ProxyItemUseContext(player, stack, new BlockHitResult(Vec3.ZERO, Direction.UP, blockPos, false)));
            if (!damageable || stack.getCount() >= count) continue;
            this.playSound(SoundEvents.ITEM_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            this.updateSlot(i);
        }
    }

    private void tryBreakBlock(ItemStack stack, BlockPos pos, Level level, Player player) {
        TagKey<Block> tag;
        BlockState state = level.getBlockState(pos);
        if (stack.getItem() instanceof HoeItem) {
            tag = AstikorCartsRedux.PLOW_BREAKABLE_HOE;
        } else if (stack.getItem() instanceof ShovelItem) {
            tag = AstikorCartsRedux.PLOW_BREAKABLE_SHOVEL;
        } else if (stack.getItem() instanceof AxeItem) {
            tag = AstikorCartsRedux.PLOW_BREAKABLE_AXE;
        } else {
            return;
        }
        if (state.isAir()) {
            return;
        }
        if (state.is(tag) && level.removeBlock(pos, false)) {
            level.destroyBlock(pos, false);
            if (!state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state)) {
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
            }
        }
    }

    @Override
    protected AbstractContainerMenu createMenuLootUnpacked(int i, Inventory inventory, Player player) {
        return new PlowMenu(i, inventory, (Container)this);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        if (!this.level().isClientSide) {
            if (((ItemStack)this.getItemStacks().get(slot)).isEmpty()) {
                this.entityData.set((EntityDataAccessor)TOOLS.get(slot), (Object)ItemStack.EMPTY);
            } else {
                this.entityData.set((EntityDataAccessor)TOOLS.get(slot), (Object)((ItemStack)this.getItemStacks().get(slot)));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.entityData.get((EntityDataAccessor)TOOLS.get(i));
    }

    @Override
    public Item getCartItem() {
        return AstikorCartsRedux.CARTS.get("plow").get(this.getWoodType()).asItem();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLOWING, (Object)false);
        for (EntityDataAccessor param : TOOLS) {
            builder.define(param, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    protected InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            this.entityData.set(PLOWING, (Object)((Boolean)this.entityData.get(PLOWING) == false ? 1 : 0));
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    @Override
    protected void saveInventory(CompoundTag tag) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readInventory(CompoundTag tag) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Plowing", ((Boolean)this.entityData.get(PLOWING)).booleanValue());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(PLOWING, (Object)compound.getBoolean("Plowing"));
    }
}

