/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import com.jusipat.astikorcartsredux.entity.PostilionEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ReaperEntity
extends AbstractDrawnEntity {
    public ReaperEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.spacing = 1.3;
    }

    @Override
    public void tick() {
        PostilionEntity postilion;
        super.tick();
        LivingEntity coachman = this.getControllingPassenger();
        Entity pulling = this.getPulling();
        if (pulling != null && coachman != null && pulling.getControllingPassenger() == null && (postilion = (PostilionEntity)AstikorCartsRedux.POSTILION_ENTITY.get().create(this.level())) != null) {
            postilion.moveTo(pulling.getX(), pulling.getY(), pulling.getZ(), coachman.getYRot(), coachman.getXRot());
            if (postilion.startRiding(pulling)) {
                this.level().addFreshEntity((Entity)postilion);
            } else {
                postilion.discard();
            }
        }
    }

    public float getPassengersRidingOffsetY(EntityDimensions entityDimensions, float f) {
        return (entityDimensions.height() - 0.1875f) * f;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        Vec3 forward = this.getLookAngle().scale(-0.45);
        return new Vec3(forward.x, (double)this.getPassengersRidingOffsetY(entityDimensions, f) + forward.y, forward.z);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (this.hasPassenger(passenger)) {
            passenger.setYBodyRot(this.getYRot());
            float f2 = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot()));
            float f1 = Mth.clamp((float)f2, (float)-105.0f, (float)105.0f);
            passenger.yRotO += f1 - f2;
            passenger.setYRot(passenger.getYRot() + (f1 - f2));
            passenger.setYHeadRot(passenger.getYRot());
        }
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (!this.level().isClientSide && !player.isSecondaryUseActive() && this.pulling != null && this.pulling != player && player.startRiding((Entity)this)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void pulledTick() {
        Entity entity;
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.level().isClientSide && (entity = this.getFirstPassenger()) instanceof Player) {
            Player pl = (Player)entity;
            if (this.xo != this.getX() || this.zo != this.getZ()) {
                this.harvest(pl);
            }
        }
    }

    private void harvest(Player player) {
        for (float f = 0.9f; f <= 2.0f; f += 0.1f) {
            double blockPosX = this.getX() + (double)(Mth.sin((float)((float)Math.toRadians(this.getYRot() + 90.0f))) * f);
            double blockPosZ = this.getZ() - (double)(Mth.cos((float)((float)Math.toRadians(this.getYRot() + 90.0f))) * f);
            BlockPos blockPos = new BlockPos((int)blockPosX, (int)Math.round(this.getY() - 0.75), (int)blockPosZ);
            BlockPos pos = blockPos.above();
            BlockState state = this.level().getBlockState(pos);
            if (!state.is(BlockTags.CROPS) || !this.level().removeBlock(pos, false)) continue;
            this.level().destroyBlock(pos, false);
            if (state.requiresCorrectToolForDrops()) continue;
            Block.dropResources((BlockState)state, (Level)this.level(), (BlockPos)pos, (BlockEntity)this.level().getBlockEntity(pos), (Entity)player, (ItemStack)ItemStack.EMPTY);
        }
    }

    @Override
    public Item getCartItem() {
        return AstikorCartsRedux.CARTS.get("reaper").get(this.getWoodType()).asItem();
    }

    @Override
    protected AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().reaper;
    }
}

