/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.google.common.collect.ImmutableList;
import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.container.SeedDrillMenu;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnInventoryEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;

public class SeedDrillEntity
extends AbstractDrawnInventoryEntity {
    private static final int SLOT_COUNT = 9;
    private static final ImmutableList<EntityDataAccessor<ItemStack>> SEEDS = ImmutableList.of((Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(SeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK));

    public SeedDrillEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn, 9);
        this.spacing = 1.3;
    }

    private void plant() {
        for (int j = 0; j < 9; ++j) {
            ItemStack stack = this.getStackInSlot(j);
            double x = this.getX() + (double)Mth.sin((float)((float)Math.toRadians(this.getYRot() - 90.0f)));
            double z = this.getZ() + (double)Mth.cos((float)((float)Math.toRadians(this.getYRot() - 90.0f)));
            BlockPos blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
            x = this.getX();
            z = this.getZ();
            blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
            x = this.getX() + (double)Mth.sin((float)((float)Math.toRadians(this.getYRot() + 90.0f)));
            z = this.getZ() + (double)Mth.cos((float)((float)Math.toRadians(this.getYRot() + 90.0f)));
            blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
        }
    }

    private boolean tryPlaceCrop(ItemStack stack, BlockPos pos, Level level, int slot) {
        Item item;
        if (stack.is(AstikorCartsRedux.SEED_DRILL_PLANTABLE) && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            Block block = item2.getBlock();
            if (level.getBlockState(pos).isAir() && block.defaultBlockState().canSurvive((LevelReader)level, pos)) {
                level.setBlockAndUpdate(pos, block.defaultBlockState());
                stack.shrink(1);
                this.onContentsChanged(slot);
                return true;
            }
        }
        return false;
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!(this.level().isClientSide || this.xo == this.getX() && this.zo == this.getZ())) {
            this.plant();
        }
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        if (!this.level().isClientSide) {
            if (((ItemStack)this.getItemStacks().get(slot)).isEmpty()) {
                this.entityData.set((EntityDataAccessor)SEEDS.get(slot), (Object)ItemStack.EMPTY);
            } else {
                this.entityData.set((EntityDataAccessor)SEEDS.get(slot), (Object)((ItemStack)this.getItemStacks().get(slot)));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.entityData.get((EntityDataAccessor)SEEDS.get(i));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        for (EntityDataAccessor param : SEEDS) {
            builder.define(param, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    protected InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        return InteractionResult.SUCCESS;
    }

    @Override
    protected AbstractContainerMenu createMenuLootUnpacked(int i, Inventory inventory, Player player) {
        return new SeedDrillMenu(i, inventory, (Container)this);
    }

    @Override
    public Item getCartItem() {
        return AstikorCartsRedux.CARTS.get("seed_drill").get(this.getWoodType()).asItem();
    }

    @Override
    protected AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().seedDrill;
    }

    @Override
    protected void saveInventory(CompoundTag compound) {
        ContainerHelper.saveAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readInventory(CompoundTag compound) {
        ContainerHelper.loadAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }
}

