/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.entity;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.entity.AbstractCargoCart;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SupplyCartEntity
extends AbstractCargoCart {
    public SupplyCartEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn, 54);
    }

    @Override
    public Item getCartItem() {
        return AstikorCartsRedux.CARTS.get("supply_cart").get(this.getWoodType()).asItem();
    }

    @Override
    protected AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().supplyCart;
    }

    public float getPassengersRidingOffsetY(EntityDimensions entityDimensions, float f) {
        return (entityDimensions.height() - 0.5625f) * f;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        Vec3 forward = this.getLookAngle().scale(-0.68);
        return new Vec3(forward.x, (double)this.getPassengersRidingOffsetY(entityDimensions, f) + forward.y, forward.z);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (this.hasPassenger(passenger)) {
            passenger.setYBodyRot(this.getYRot() + 180.0f);
            float f2 = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot() + 180.0f));
            float f1 = Mth.clamp((float)f2, (float)-105.0f, (float)105.0f);
            passenger.yRotO += f1 - f2;
            passenger.setYRot(passenger.getYRot() + (f1 - f2));
            passenger.setYHeadRot(passenger.getYRot());
        }
    }

    @Override
    protected InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        InteractionResult bannerResult = this.useBanner(player, hand);
        if (bannerResult.consumesAction()) {
            return bannerResult;
        }
        if (this.isVehicle()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected AbstractContainerMenu createMenuLootUnpacked(int i, Inventory inventory, Player player) {
        return ChestMenu.sixRows((int)i, (Inventory)inventory, (Container)this);
    }
}

