/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.item;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CartItem
extends Item {
    private final WoodType woodType;
    private final String cartType;

    public CartItem(WoodType type, String cartType, Item.Properties settings) {
        super(settings);
        this.woodType = type;
        this.cartType = cartType;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)("item." + this.cartType + ".tooltip1")).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)("item." + this.cartType + ".tooltip2")).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        BlockHitResult result = CartItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 lookVec = player.getLookAngle();
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(lookVec.scale(5.0)).inflate(5.0), EntitySelector.NO_SPECTATORS.and(Entity::canBeCollidedWith));
        if (!list.isEmpty()) {
            Vec3 eyePos = player.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedbb.contains(eyePos)) continue;
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)this.cartType));
            Entity cart = type.create(level);
            if (cart == null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (cart instanceof AbstractDrawnEntity) {
                AbstractDrawnEntity drawn = (AbstractDrawnEntity)cart;
                drawn.setWoodType(this.woodType);
            }
            cart.moveTo(result.getLocation().x, result.getLocation().y, result.getLocation().z);
            cart.setYRot((player.getYRot() + 180.0f) % 360.0f);
            if (!level.noCollision(cart, cart.getBoundingBox().inflate((double)0.1f, (double)-0.1f, (double)0.1f))) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!level.isClientSide()) {
                level.addFreshEntity(cart);
                level.playSound(null, cart.getX(), cart.getY(), cart.getZ(), AstikorCartsRedux.PLACE_SOUND, SoundSource.BLOCKS, 0.75f, 0.8f);
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

