/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.network.serverbound;

import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import com.jusipat.astikorcartsredux.network.clientbound.UpdateDrawnPayload;
import com.jusipat.astikorcartsredux.util.NiftyWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RequestCartUpdatePayload(int cartId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestCartUpdatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"astikorcartsredux", (String)"astikorcartsredux_request_cart_update"));
    public static final StreamCodec<FriendlyByteBuf, RequestCartUpdatePayload> CODEC = new StreamCodec<FriendlyByteBuf, RequestCartUpdatePayload>(){

        @NotNull
        public RequestCartUpdatePayload decode(FriendlyByteBuf buf) {
            return new RequestCartUpdatePayload(buf.readVarInt());
        }

        public void encode(FriendlyByteBuf buf, RequestCartUpdatePayload payload) {
            buf.writeVarInt(payload.cartId());
        }
    };

    public static void handle(RequestCartUpdatePayload payload, IPayloadContext ctx) {
        Level level = ctx.player().level();
        Int2ObjectMap<AbstractDrawnEntity> pulling = NiftyWorld.get(level).getPulling();
        pulling.keySet().intStream().filter(pullId -> NiftyWorld.get(level).getDrawn(level.getEntity(pullId)).map(Entity::getId).orElse(-1) == payload.cartId).findFirst().ifPresent(pullId -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)ctx.player()), (CustomPacketPayload)new UpdateDrawnPayload(pullId, payload.cartId), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

