/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.util;

import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractDrawnEntity cart;

    public CartWheel(AbstractDrawnEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.getX();
        this.posZ = this.prevPosZ = cartIn.getZ();
    }

    public CartWheel(AbstractDrawnEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.getYRot());
        float nx = -Mth.sin((float)yaw);
        float nz = Mth.cos((float)yaw);
        this.posX = this.cart.getX() + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.getZ() + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = dx / (double)distanceTravelled;
        double dzNormalized = dz / (double)distanceTravelled;
        float travelledForward = Mth.sign((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.2) {
            BlockPos blockpos = new BlockPos(Mth.floor((double)this.posX), Mth.floor((double)(this.cart.getY() - (double)0.2f)), Mth.floor((double)this.posZ));
            BlockState blockstate = this.cart.level().getBlockState(blockpos);
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                this.cart.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), this.posX, this.cart.getY(), this.posZ, dx, (double)distanceTravelled, dz);
            }
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public void clearIncrement() {
        this.rotationIncrement = 0.0f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationIncrement() {
        return this.rotationIncrement;
    }
}

