/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NCInventory
extends NonNullList<ItemStack> {
    private Consumer<Integer> onContentsChanged;

    public static NCInventory create() {
        return new NCInventory(Lists.newArrayList(), null);
    }

    public static NCInventory createWithCapacity(int i) {
        return new NCInventory(Lists.newArrayListWithCapacity((int)i), null);
    }

    public static NCInventory withSize(int i, ItemStack object) {
        Validate.notNull((Object)object, (String)"ItemStack is null", (Object[])new Object[0]);
        Object[] objects = new ItemStack[i];
        Arrays.fill(objects, object);
        return new NCInventory(Arrays.asList(objects), object);
    }

    public NCInventory(List<ItemStack> list, @Nullable ItemStack object) {
        super(list, (Object)object);
    }

    public void setOnContentsChanged(Consumer<Integer> onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    @NotNull
    public ItemStack set(int i, ItemStack object) {
        ItemStack out = (ItemStack)super.set(i, (Object)object);
        this.onContentsChanged.accept(i);
        return out;
    }

    public void add(int i, ItemStack object) {
        super.add(i, (Object)object);
        this.onContentsChanged.accept(i);
    }

    public ItemStack remove(int i) {
        ItemStack out = (ItemStack)super.remove(i);
        this.onContentsChanged.accept(i);
        return out;
    }

    public void clear() {
        int size = this.size();
        super.clear();
        for (int i = 0; i < size; ++i) {
            this.onContentsChanged.accept(i);
        }
    }
}

