/*
 * Decompiled with CFR 0.152.
 */
package com.jusipat.astikorcartsredux.util;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NiftyWorld
extends SavedData {
    private static NiftyWorld clientInstance = null;
    private final Int2ObjectMap<AbstractDrawnEntity> pulling = new Int2ObjectOpenHashMap();

    public void addPulling(AbstractDrawnEntity drawn) {
        @Nullable Entity pulling = drawn.getPulling();
        if (pulling != null) {
            this.pulling.put(pulling.getId(), (Object)drawn);
            this.setDirty();
        }
    }

    public void setPulling(int pullId, AbstractDrawnEntity drawn) {
        this.pulling.put(pullId, (Object)drawn);
        this.setDirty();
    }

    public Optional<AbstractDrawnEntity> getDrawn(Entity e) {
        if (e == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((AbstractDrawnEntity)((Object)this.pulling.get(e.getId())));
    }

    public boolean isPulling(Entity e) {
        return this.pulling.containsKey(e.getId());
    }

    public void tick() {
        IntIterator it = this.pulling.keySet().iterator();
        while (it.hasNext()) {
            int pullId = (Integer)it.next();
            AbstractDrawnEntity cart = (AbstractDrawnEntity)((Object)this.pulling.get(pullId));
            if (cart.shouldStopPulledTick()) {
                it.remove();
                this.setDirty();
                continue;
            }
            if (cart.getPulling() instanceof AbstractDrawnEntity) continue;
            cart.pulledTick();
        }
    }

    public Optional<Entity> getCurrentlyPulling(AbstractDrawnEntity drawn) {
        OptionalInt id = this.pulling.keySet().intStream().filter(pullID -> this.pulling.get(pullID) == drawn).findFirst();
        if (id.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(drawn.level().getEntity(id.getAsInt()));
    }

    public Int2ObjectMap<AbstractDrawnEntity> getPulling() {
        return this.pulling;
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag drawnList = new ListTag();
        for (AbstractDrawnEntity drawn : this.pulling.values()) {
            drawnList.add((Object)NbtUtils.createUUID((UUID)drawn.getUUID()));
        }
        tag.put("drawnList", (Tag)drawnList);
        return tag;
    }

    public static NiftyWorld createFromNbt(CompoundTag tag, ServerLevel level) {
        NiftyWorld data = new NiftyWorld();
        ListTag drawnList = tag.getList("drawnList", 11);
        for (Tag item : drawnList) {
            UUID uuid = NbtUtils.loadUUID((Tag)item);
            Entity entity = level.getEntity(uuid);
            if (!(entity instanceof AbstractDrawnEntity)) continue;
            AbstractDrawnEntity drawn = (AbstractDrawnEntity)entity;
            data.addPulling(drawn);
        }
        return data;
    }

    public static NiftyWorld get(Level level) {
        if (level.isClientSide()) {
            return NiftyWorld.getClient();
        }
        return NiftyWorld.getServer(AstikorCartsRedux.server, (ResourceKey<Level>)level.dimension());
    }

    public static NiftyWorld getClient() {
        if (clientInstance == null) {
            clientInstance = new NiftyWorld();
        }
        return clientInstance;
    }

    public static NiftyWorld getServer(MinecraftServer server, ResourceKey<Level> levelType) {
        DimensionDataStorage dataStorage = Objects.requireNonNull(server.getLevel(levelType)).getDataStorage();
        SavedData.Factory factory = new SavedData.Factory(NiftyWorld::new, (tag, provider) -> NiftyWorld.createFromNbt(tag, server.getLevel(levelType)), null);
        return (NiftyWorld)dataStorage.computeIfAbsent(factory, "astikorcartsredux");
    }
}

