/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GarageDoor
extends Block {
    public static final EnumProperty<GaragePart> PART = EnumProperty.create((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape EAST = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing == Direction.WEST || facing == Direction.EAST) {
            return NORTH;
        }
        return EAST;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.empty();
        }
        return state.getValue((Property)FACING) == Direction.WEST || state.getValue((Property)FACING) == Direction.EAST ? NORTH : EAST;
    }

    public GarageDoor(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    protected BlockState GarageState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean bl = below = level.getBlockState(pos.below()).getBlock() == this;
        if (above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.MIDDLE));
        }
        if (!above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.GarageState(state, (LevelAccessor)level, pos);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.GarageState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.GarageState(state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING, POWERED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void openDoor(Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == this.asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.garageDoor(level, pos, (Boolean)state.getValue((Property)OPEN) == false, (Direction)state.getValue((Property)FACING));
        level.playSound(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 10);
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level level, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(stateIn, facing, facingState, (LevelAccessor)level, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        Block block = level.getBlockState(pos).getBlock();
        Block upper = level.getBlockState(pos.above(1)).getBlock();
        Block lower = level.getBlockState(pos.below(1)).getBlock();
        if (upper == block && lower == block) {
            level.setBlockAndUpdate(pos.below(1), (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP)));
        } else if (lower == block) {
            level.setBlockAndUpdate(pos.below(1), (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP)));
        }
        level.playSound(null, pos, SoundEvents.METAL_BREAK, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        if (!(((Boolean)state.getValue((Property)OPEN)).booleanValue() && state.getValue(PART) == GaragePart.BOTTOM || state.getValue(PART) == GaragePart.MIDDLE)) {
            this.spawnDestroyParticles(level, player, pos, state);
        }
        return state;
    }

    private void garageDoor(Level world, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == this && (Boolean)state.getValue((Property)OPEN) != bool && ((Direction)state.getValue((Property)FACING)).equals((Object)dir)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.offset(x, y, z);
                        this.garageDoor(world, newPos, bool, dir);
                    }
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        if (!level.isClientSide) {
            boolean powered;
            boolean bl = powered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            if ((Boolean)state.getValue((Property)POWERED) != powered) {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if ((Boolean)state.getValue((Property)OPEN) != powered) {
                    this.garageDoor(level, pos, (Boolean)state.getValue((Property)OPEN) == false, (Direction)state.getValue((Property)FACING));
                    level.playSound(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
                }
            }
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType path) {
        return false;
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

