/*
 * Decompiled with CFR 0.152.
 */
package com.example.cropgrowthcustomization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class Config {
    public static double ONLINE_GROWTH_MULTIPLIER = 1.0;
    public static boolean ONLINE_ACCEL_ONLY_WITH_PLAYERS = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "crop_growth_customization.json");

    public static void register() {
        Config.load();
    }

    public static synchronized void load() {
        Settings s;
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                s = (Settings)GSON.fromJson((Reader)r, Settings.class);
                if (s == null) {
                    s = new Settings();
                }
            }
            catch (JsonSyntaxException | IOException ex) {
                s = new Settings();
            }
        } else {
            s = new Settings();
        }
        ONLINE_GROWTH_MULTIPLIER = Config.clampDouble(s.onlineGrowthMultiplier, 0.0, 32.0);
        ONLINE_ACCEL_ONLY_WITH_PLAYERS = s.onlineAccelOnlyWithPlayers;
        Config.save();
    }

    public static synchronized void save() {
        Settings out = new Settings();
        out.onlineGrowthMultiplier = ONLINE_GROWTH_MULTIPLIER;
        out.onlineAccelOnlyWithPlayers = ONLINE_ACCEL_ONLY_WITH_PLAYERS;
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)out, (Appendable)w);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static double clampDouble(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private Config() {
    }

    public static final class Settings {
        public double onlineGrowthMultiplier = 1.0;
        public boolean onlineAccelOnlyWithPlayers = true;
    }
}

