/*
 * Decompiled with CFR 0.152.
 */
package com.example.cropgrowthcustomization;

import com.example.cropgrowthcustomization.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="cropgrowthcustomization")
public class CropGrowthCustomizationNeo {
    private final Map<ServerLevel, Map<BlockPos, Integer>> onlineExtraNextTick = new HashMap<ServerLevel, Map<BlockPos, Integer>>();
    private final Map<ServerLevel, Map<BlockPos, Integer>> onlineExtraActive = new HashMap<ServerLevel, Map<BlockPos, Integer>>();
    private static final int ONLINE_EXTRA_APPLIES_PER_TICK = 256;

    public CropGrowthCustomizationNeo(IEventBus modEventBus) {
        System.out.println("[OfflineGrowth] Loading config...");
        Config.register();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onCropGrowPre(CropGrowEvent.Pre e) {
        double mult = Math.max(0.0, Config.ONLINE_GROWTH_MULTIPLIER);
        if (mult >= 0.9999) {
            return;
        }
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (Config.ONLINE_ACCEL_ONLY_WITH_PLAYERS && level.players().isEmpty()) {
            return;
        }
        if (level.getRandom().nextDouble() > mult) {
            e.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
        }
    }

    @SubscribeEvent
    public void onCropGrowPost(CropGrowEvent.Post e) {
        double mult = Math.max(0.0, Config.ONLINE_GROWTH_MULTIPLIER);
        if (mult <= 1.0001) {
            return;
        }
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (Config.ONLINE_ACCEL_ONLY_WITH_PLAYERS && level.players().isEmpty()) {
            return;
        }
        int extra = (int)Math.floor(mult) - 1;
        double frac = mult - Math.floor(mult);
        if (level.getRandom().nextDouble() < frac) {
            ++extra;
        }
        if (extra <= 0) {
            return;
        }
        this.onlineExtraNextTick.computeIfAbsent(level, k -> new HashMap()).merge(e.getPos().immutable(), extra, Integer::sum);
    }

    @SubscribeEvent
    public void onServerTickPre(ServerTickEvent.Pre e) {
        MinecraftServer server = e.getServer();
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            Map<BlockPos, Integer> pending = this.onlineExtraNextTick.remove(level);
            if (pending == null || pending.isEmpty()) continue;
            Map active = this.onlineExtraActive.computeIfAbsent(level, k -> new HashMap());
            for (Map.Entry<BlockPos, Integer> entry : pending.entrySet()) {
                active.merge(entry.getKey(), entry.getValue(), Integer::sum);
            }
        }
    }

    @SubscribeEvent
    public void onServerTickEnd(ServerTickEvent.Post e) {
        MinecraftServer server = e.getServer();
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            Map<BlockPos, Integer> active = this.onlineExtraActive.get(level);
            if (active == null || active.isEmpty()) continue;
            int applied = 0;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>(active.keySet());
            for (BlockPos pos : positions) {
                int max;
                if (applied >= 256) break;
                BlockState state = level.getBlockState(pos);
                IntegerProperty age = CropGrowthCustomizationNeo.getAgeProperty(state);
                if (age == null) {
                    active.remove(pos);
                    continue;
                }
                int cur = (Integer)state.getValue((Property)age);
                if (cur >= (max = CropGrowthCustomizationNeo.getMax(age))) {
                    active.remove(pos);
                    continue;
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)age, (Comparable)Integer.valueOf(cur + 1)), 2);
                ++applied;
                int left = active.getOrDefault(pos, 0) - 1;
                if (left <= 0) {
                    active.remove(pos);
                    continue;
                }
                active.put(pos, left);
            }
            if (!active.isEmpty()) continue;
            this.onlineExtraActive.remove(level);
        }
    }

    @Nullable
    private static IntegerProperty getAgeProperty(BlockState state) {
        for (Property p : state.getProperties()) {
            if (!(p instanceof IntegerProperty)) continue;
            IntegerProperty ip = (IntegerProperty)p;
            if (!"age".equals(p.getName())) continue;
            return ip;
        }
        return null;
    }

    private static int getMax(IntegerProperty prop) {
        int max = Integer.MIN_VALUE;
        for (Integer v : prop.getPossibleValues()) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }
}

